/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.PacketDataSerializer;

public record SculkChargeParticleOptions(float roll) implements ParticleParam
{
    public static final Codec<SculkChargeParticleOptions> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.FLOAT.fieldOf("roll").forGetter(var0 -> Float.valueOf(var0.roll))).apply((Applicative)var02, SculkChargeParticleOptions::new));
    public static final ParticleParam.a<SculkChargeParticleOptions> DESERIALIZER = new ParticleParam.a<SculkChargeParticleOptions>(){

        @Override
        public SculkChargeParticleOptions fromCommand(Particle<SculkChargeParticleOptions> var0, StringReader var1) throws CommandSyntaxException {
            var1.expect(' ');
            float var2 = var1.readFloat();
            return new SculkChargeParticleOptions(var2);
        }

        @Override
        public SculkChargeParticleOptions fromNetwork(Particle<SculkChargeParticleOptions> var0, PacketDataSerializer var1) {
            return new SculkChargeParticleOptions(var1.readFloat());
        }

        @Override
        public /* synthetic */ ParticleParam fromNetwork(Particle particle, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(particle, packetDataSerializer);
        }

        @Override
        public /* synthetic */ ParticleParam fromCommand(Particle particle, StringReader stringReader) throws CommandSyntaxException {
            return this.fromCommand(particle, stringReader);
        }
    };

    public Particle<SculkChargeParticleOptions> getType() {
        return Particles.SCULK_CHARGE;
    }

    @Override
    public void writeToNetwork(PacketDataSerializer var0) {
        var0.writeFloat(this.roll);
    }

    @Override
    public String writeToString() {
        return String.format(Locale.ROOT, "%s %.2f", IRegistry.PARTICLE_TYPE.getKey(this.getType()), Float.valueOf(this.roll));
    }
}

