/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import net.minecraft.commands.arguments.item.ArgumentParserItemStack;
import net.minecraft.commands.arguments.item.ArgumentPredicateItemStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.item.ItemStack;

public class ParticleParamItem
implements ParticleParam {
    public static final ParticleParam.a<ParticleParamItem> DESERIALIZER = new ParticleParam.a<ParticleParamItem>(){

        @Override
        public ParticleParamItem fromCommand(Particle<ParticleParamItem> var0, StringReader var1) throws CommandSyntaxException {
            var1.expect(' ');
            ArgumentParserItemStack.a var2 = ArgumentParserItemStack.parseForItem(HolderLookup.forRegistry(IRegistry.ITEM), var1);
            ItemStack var3 = new ArgumentPredicateItemStack(var2.item(), var2.nbt()).createItemStack(1, false);
            return new ParticleParamItem(var0, var3);
        }

        @Override
        public ParticleParamItem fromNetwork(Particle<ParticleParamItem> var0, PacketDataSerializer var1) {
            return new ParticleParamItem(var0, var1.readItem());
        }

        @Override
        public /* synthetic */ ParticleParam fromNetwork(Particle particle, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(particle, packetDataSerializer);
        }

        @Override
        public /* synthetic */ ParticleParam fromCommand(Particle particle, StringReader stringReader) throws CommandSyntaxException {
            return this.fromCommand(particle, stringReader);
        }
    };
    private final Particle<ParticleParamItem> type;
    private final ItemStack itemStack;

    public static Codec<ParticleParamItem> codec(Particle<ParticleParamItem> var02) {
        return ItemStack.CODEC.xmap(var1 -> new ParticleParamItem(var02, (ItemStack)var1), var0 -> var0.itemStack);
    }

    public ParticleParamItem(Particle<ParticleParamItem> var0, ItemStack var1) {
        this.type = var0;
        this.itemStack = var1;
    }

    @Override
    public void writeToNetwork(PacketDataSerializer var0) {
        var0.writeItem(this.itemStack);
    }

    @Override
    public String writeToString() {
        return IRegistry.PARTICLE_TYPE.getKey(this.getType()) + " " + new ArgumentPredicateItemStack(this.itemStack.getItemHolder(), this.itemStack.getTag()).serialize();
    }

    public Particle<ParticleParamItem> getType() {
        return this.type;
    }

    public ItemStack getItem() {
        return this.itemStack;
    }
}

