/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3fa;
import com.mojang.math.Vector4f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public final class EnumDirection
extends Enum<EnumDirection>
implements INamable {
    public static final /* enum */ EnumDirection DOWN = new EnumDirection(0, 1, -1, "down", EnumAxisDirection.NEGATIVE, EnumAxis.Y, new BaseBlockPosition(0, -1, 0));
    public static final /* enum */ EnumDirection UP = new EnumDirection(1, 0, -1, "up", EnumAxisDirection.POSITIVE, EnumAxis.Y, new BaseBlockPosition(0, 1, 0));
    public static final /* enum */ EnumDirection NORTH = new EnumDirection(2, 3, 2, "north", EnumAxisDirection.NEGATIVE, EnumAxis.Z, new BaseBlockPosition(0, 0, -1));
    public static final /* enum */ EnumDirection SOUTH = new EnumDirection(3, 2, 0, "south", EnumAxisDirection.POSITIVE, EnumAxis.Z, new BaseBlockPosition(0, 0, 1));
    public static final /* enum */ EnumDirection WEST = new EnumDirection(4, 5, 1, "west", EnumAxisDirection.NEGATIVE, EnumAxis.X, new BaseBlockPosition(-1, 0, 0));
    public static final /* enum */ EnumDirection EAST = new EnumDirection(5, 4, 3, "east", EnumAxisDirection.POSITIVE, EnumAxis.X, new BaseBlockPosition(1, 0, 0));
    public static final INamable.a<EnumDirection> CODEC;
    public static final Codec<EnumDirection> VERTICAL_CODEC;
    private final int data3d;
    private final int oppositeIndex;
    private final int data2d;
    private final String name;
    private final EnumAxis axis;
    private final EnumAxisDirection axisDirection;
    private final BaseBlockPosition normal;
    private static final EnumDirection[] VALUES;
    private static final EnumDirection[] BY_3D_DATA;
    private static final EnumDirection[] BY_2D_DATA;
    private static final Long2ObjectMap<EnumDirection> BY_NORMAL;
    private static final /* synthetic */ EnumDirection[] t;

    public static EnumDirection[] values() {
        return (EnumDirection[])t.clone();
    }

    public static EnumDirection valueOf(String var0) {
        return Enum.valueOf(EnumDirection.class, var0);
    }

    private EnumDirection(int var2, int var3, int var4, String var5, EnumAxisDirection var6, EnumAxis var7, BaseBlockPosition var8) {
        this.data3d = var2;
        this.data2d = var4;
        this.oppositeIndex = var3;
        this.name = var5;
        this.axis = var7;
        this.axisDirection = var6;
        this.normal = var8;
    }

    public static EnumDirection[] orderedByNearest(Entity var0) {
        EnumDirection var17;
        float var1 = var0.getViewXRot(1.0f) * ((float)Math.PI / 180);
        float var2 = -var0.getViewYRot(1.0f) * ((float)Math.PI / 180);
        float var3 = MathHelper.sin(var1);
        float var4 = MathHelper.cos(var1);
        float var5 = MathHelper.sin(var2);
        float var6 = MathHelper.cos(var2);
        boolean var7 = var5 > 0.0f;
        boolean var8 = var3 < 0.0f;
        boolean var9 = var6 > 0.0f;
        float var10 = var7 ? var5 : -var5;
        float var11 = var8 ? -var3 : var3;
        float var12 = var9 ? var6 : -var6;
        float var13 = var10 * var4;
        float var14 = var12 * var4;
        EnumDirection var15 = var7 ? EAST : WEST;
        EnumDirection var16 = var8 ? UP : DOWN;
        EnumDirection enumDirection = var17 = var9 ? SOUTH : NORTH;
        if (var10 > var12) {
            if (var11 > var13) {
                return EnumDirection.makeDirectionArray(var16, var15, var17);
            }
            if (var14 > var11) {
                return EnumDirection.makeDirectionArray(var15, var17, var16);
            }
            return EnumDirection.makeDirectionArray(var15, var16, var17);
        }
        if (var11 > var14) {
            return EnumDirection.makeDirectionArray(var16, var17, var15);
        }
        if (var13 > var11) {
            return EnumDirection.makeDirectionArray(var17, var15, var16);
        }
        return EnumDirection.makeDirectionArray(var17, var16, var15);
    }

    private static EnumDirection[] makeDirectionArray(EnumDirection var0, EnumDirection var1, EnumDirection var2) {
        return new EnumDirection[]{var0, var1, var2, var2.getOpposite(), var1.getOpposite(), var0.getOpposite()};
    }

    public static EnumDirection rotate(Matrix4f var0, EnumDirection var1) {
        BaseBlockPosition var2 = var1.getNormal();
        Vector4f var3 = new Vector4f(var2.getX(), var2.getY(), var2.getZ(), 0.0f);
        var3.transform(var0);
        return EnumDirection.getNearest(var3.x(), var3.y(), var3.z());
    }

    public static Collection<EnumDirection> allShuffled(RandomSource var0) {
        return SystemUtils.shuffledCopy(EnumDirection.values(), var0);
    }

    public static Stream<EnumDirection> stream() {
        return Stream.of(VALUES);
    }

    public Quaternion getRotation() {
        Quaternion var0 = Vector3fa.XP.rotationDegrees(90.0f);
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case DOWN -> Vector3fa.XP.rotationDegrees(180.0f);
            case UP -> Quaternion.ONE.copy();
            case NORTH -> {
                var0.mul(Vector3fa.ZP.rotationDegrees(180.0f));
                yield var0;
            }
            case SOUTH -> var0;
            case WEST -> {
                var0.mul(Vector3fa.ZP.rotationDegrees(90.0f));
                yield var0;
            }
            case EAST -> {
                var0.mul(Vector3fa.ZP.rotationDegrees(-90.0f));
                yield var0;
            }
        };
    }

    public int get3DDataValue() {
        return this.data3d;
    }

    public int get2DDataValue() {
        return this.data2d;
    }

    public EnumAxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public static EnumDirection getFacingAxis(Entity var0, EnumAxis var1) {
        return switch (var1) {
            default -> throw new IncompatibleClassChangeError();
            case EnumAxis.X -> {
                if (EAST.isFacingAngle(var0.getViewYRot(1.0f))) {
                    yield EAST;
                }
                yield WEST;
            }
            case EnumAxis.Z -> {
                if (SOUTH.isFacingAngle(var0.getViewYRot(1.0f))) {
                    yield SOUTH;
                }
                yield NORTH;
            }
            case EnumAxis.Y -> var0.getViewXRot(1.0f) < 0.0f ? UP : DOWN;
        };
    }

    public EnumDirection getOpposite() {
        return EnumDirection.from3DDataValue(this.oppositeIndex);
    }

    public EnumDirection getClockWise(EnumAxis var0) {
        return switch (var0) {
            default -> throw new IncompatibleClassChangeError();
            case EnumAxis.X -> {
                if (this == WEST || this == EAST) {
                    yield this;
                }
                yield this.getClockWiseX();
            }
            case EnumAxis.Y -> {
                if (this == UP || this == DOWN) {
                    yield this;
                }
                yield this.getClockWise();
            }
            case EnumAxis.Z -> this == NORTH || this == SOUTH ? this : this.getClockWiseZ();
        };
    }

    public EnumDirection getCounterClockWise(EnumAxis var0) {
        return switch (var0) {
            default -> throw new IncompatibleClassChangeError();
            case EnumAxis.X -> {
                if (this == WEST || this == EAST) {
                    yield this;
                }
                yield this.getCounterClockWiseX();
            }
            case EnumAxis.Y -> {
                if (this == UP || this == DOWN) {
                    yield this;
                }
                yield this.getCounterClockWise();
            }
            case EnumAxis.Z -> this == NORTH || this == SOUTH ? this : this.getCounterClockWiseZ();
        };
    }

    public EnumDirection getClockWise() {
        return switch (this) {
            case NORTH -> EAST;
            case EAST -> SOUTH;
            case SOUTH -> WEST;
            case WEST -> NORTH;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + this);
        };
    }

    private EnumDirection getClockWiseX() {
        return switch (this) {
            case UP -> NORTH;
            case NORTH -> DOWN;
            case DOWN -> SOUTH;
            case SOUTH -> UP;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + this);
        };
    }

    private EnumDirection getCounterClockWiseX() {
        return switch (this) {
            case UP -> SOUTH;
            case SOUTH -> DOWN;
            case DOWN -> NORTH;
            case NORTH -> UP;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + this);
        };
    }

    private EnumDirection getClockWiseZ() {
        return switch (this) {
            case UP -> EAST;
            case EAST -> DOWN;
            case DOWN -> WEST;
            case WEST -> UP;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
        };
    }

    private EnumDirection getCounterClockWiseZ() {
        return switch (this) {
            case UP -> WEST;
            case WEST -> DOWN;
            case DOWN -> EAST;
            case EAST -> UP;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
        };
    }

    public EnumDirection getCounterClockWise() {
        return switch (this) {
            case NORTH -> WEST;
            case EAST -> NORTH;
            case SOUTH -> EAST;
            case WEST -> SOUTH;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + this);
        };
    }

    public int getStepX() {
        return this.normal.getX();
    }

    public int getStepY() {
        return this.normal.getY();
    }

    public int getStepZ() {
        return this.normal.getZ();
    }

    public Vector3fa step() {
        return new Vector3fa(this.getStepX(), this.getStepY(), this.getStepZ());
    }

    public String getName() {
        return this.name;
    }

    public EnumAxis getAxis() {
        return this.axis;
    }

    @Nullable
    public static EnumDirection byName(@Nullable String var0) {
        return CODEC.byName(var0);
    }

    public static EnumDirection from3DDataValue(int var0) {
        return BY_3D_DATA[MathHelper.abs(var0 % BY_3D_DATA.length)];
    }

    public static EnumDirection from2DDataValue(int var0) {
        return BY_2D_DATA[MathHelper.abs(var0 % BY_2D_DATA.length)];
    }

    @Nullable
    public static EnumDirection fromNormal(BlockPosition var0) {
        return (EnumDirection)BY_NORMAL.get(var0.asLong());
    }

    @Nullable
    public static EnumDirection fromNormal(int var0, int var1, int var2) {
        return (EnumDirection)BY_NORMAL.get(BlockPosition.asLong(var0, var1, var2));
    }

    public static EnumDirection fromYRot(double var0) {
        return EnumDirection.from2DDataValue(MathHelper.floor(var0 / 90.0 + 0.5) & 3);
    }

    public static EnumDirection fromAxisAndDirection(EnumAxis var0, EnumAxisDirection var1) {
        return switch (var0) {
            default -> throw new IncompatibleClassChangeError();
            case EnumAxis.X -> {
                if (var1 == EnumAxisDirection.POSITIVE) {
                    yield EAST;
                }
                yield WEST;
            }
            case EnumAxis.Y -> {
                if (var1 == EnumAxisDirection.POSITIVE) {
                    yield UP;
                }
                yield DOWN;
            }
            case EnumAxis.Z -> var1 == EnumAxisDirection.POSITIVE ? SOUTH : NORTH;
        };
    }

    public float toYRot() {
        return (this.data2d & 3) * 90;
    }

    public static EnumDirection getRandom(RandomSource var0) {
        return SystemUtils.getRandom(VALUES, var0);
    }

    public static EnumDirection getNearest(double var0, double var2, double var4) {
        return EnumDirection.getNearest((float)var0, (float)var2, (float)var4);
    }

    public static EnumDirection getNearest(float var0, float var1, float var2) {
        EnumDirection var3 = NORTH;
        float var4 = Float.MIN_VALUE;
        for (EnumDirection var8 : VALUES) {
            float var9 = var0 * (float)var8.normal.getX() + var1 * (float)var8.normal.getY() + var2 * (float)var8.normal.getZ();
            if (!(var9 > var4)) continue;
            var4 = var9;
            var3 = var8;
        }
        return var3;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    private static DataResult<EnumDirection> verifyVertical(EnumDirection var0) {
        return var0.getAxis().isVertical() ? DataResult.success((Object)var0) : DataResult.error((String)"Expected a vertical direction");
    }

    public static EnumDirection get(EnumAxisDirection var0, EnumAxis var1) {
        for (EnumDirection var5 : VALUES) {
            if (var5.getAxisDirection() != var0 || var5.getAxis() != var1) continue;
            return var5;
        }
        throw new IllegalArgumentException("No such direction: " + var0 + " " + var1);
    }

    public BaseBlockPosition getNormal() {
        return this.normal;
    }

    public boolean isFacingAngle(float var0) {
        float var1 = var0 * ((float)Math.PI / 180);
        float var2 = -MathHelper.sin(var1);
        float var3 = MathHelper.cos(var1);
        return (float)this.normal.getX() * var2 + (float)this.normal.getZ() * var3 > 0.0f;
    }

    private static /* synthetic */ EnumDirection[] v() {
        return new EnumDirection[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    }

    static {
        t = EnumDirection.v();
        CODEC = INamable.fromEnum(EnumDirection::values);
        VERTICAL_CODEC = CODEC.flatXmap(EnumDirection::verifyVertical, EnumDirection::verifyVertical);
        VALUES = EnumDirection.values();
        BY_3D_DATA = (EnumDirection[])Arrays.stream(VALUES).sorted(Comparator.comparingInt(var0 -> var0.data3d)).toArray(EnumDirection[]::new);
        BY_2D_DATA = (EnumDirection[])Arrays.stream(VALUES).filter(var0 -> var0.getAxis().isHorizontal()).sorted(Comparator.comparingInt(var0 -> var0.data2d)).toArray(EnumDirection[]::new);
        BY_NORMAL = (Long2ObjectMap)Arrays.stream(VALUES).collect(Collectors.toMap(var0 -> new BlockPosition(var0.getNormal()).asLong(), var0 -> var0, (var0, var1) -> {
            throw new IllegalArgumentException("Duplicate keys");
        }, Long2ObjectOpenHashMap::new));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class EnumAxis
    extends Enum<EnumAxis>
    implements INamable,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumAxis X = new EnumAxis("x"){

            @Override
            public int choose(int var0, int var1, int var2) {
                return var0;
            }

            @Override
            public double choose(double var0, double var2, double var4) {
                return var0;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((EnumDirection)object);
            }
        };
        public static final /* enum */ EnumAxis Y = new EnumAxis("y"){

            @Override
            public int choose(int var0, int var1, int var2) {
                return var1;
            }

            @Override
            public double choose(double var0, double var2, double var4) {
                return var2;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((EnumDirection)object);
            }
        };
        public static final /* enum */ EnumAxis Z = new EnumAxis("z"){

            @Override
            public int choose(int var0, int var1, int var2) {
                return var2;
            }

            @Override
            public double choose(double var0, double var2, double var4) {
                return var4;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((EnumDirection)object);
            }
        };
        public static final EnumAxis[] VALUES;
        public static final INamable.a<EnumAxis> CODEC;
        private final String name;
        private static final /* synthetic */ EnumAxis[] g;

        public static EnumAxis[] values() {
            return (EnumAxis[])g.clone();
        }

        public static EnumAxis valueOf(String var0) {
            return Enum.valueOf(EnumAxis.class, var0);
        }

        EnumAxis(String var2) {
            this.name = var2;
        }

        @Nullable
        public static EnumAxis byName(String var0) {
            return CODEC.byName(var0);
        }

        public String getName() {
            return this.name;
        }

        public boolean isVertical() {
            return this == Y;
        }

        public boolean isHorizontal() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.name;
        }

        public static EnumAxis getRandom(RandomSource var0) {
            return SystemUtils.getRandom(VALUES, var0);
        }

        @Override
        public boolean test(@Nullable EnumDirection var0) {
            return var0 != null && var0.getAxis() == this;
        }

        public EnumDirectionLimit getPlane() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case X, Z -> EnumDirectionLimit.HORIZONTAL;
                case Y -> EnumDirectionLimit.VERTICAL;
            };
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public abstract int choose(int var1, int var2, int var3);

        public abstract double choose(double var1, double var3, double var5);

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((EnumDirection)object);
        }

        private static /* synthetic */ EnumAxis[] f() {
            return new EnumAxis[]{X, Y, Z};
        }

        static {
            g = EnumAxis.f();
            VALUES = EnumAxis.values();
            CODEC = INamable.fromEnum(EnumAxis::values);
        }
    }

    public static final class EnumAxisDirection
    extends Enum<EnumAxisDirection> {
        public static final /* enum */ EnumAxisDirection POSITIVE = new EnumAxisDirection(1, "Towards positive");
        public static final /* enum */ EnumAxisDirection NEGATIVE = new EnumAxisDirection(-1, "Towards negative");
        private final int step;
        private final String name;
        private static final /* synthetic */ EnumAxisDirection[] e;

        public static EnumAxisDirection[] values() {
            return (EnumAxisDirection[])e.clone();
        }

        public static EnumAxisDirection valueOf(String var0) {
            return Enum.valueOf(EnumAxisDirection.class, var0);
        }

        private EnumAxisDirection(int var2, String var3) {
            this.step = var2;
            this.name = var3;
        }

        public int getStep() {
            return this.step;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public EnumAxisDirection opposite() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }

        private static /* synthetic */ EnumAxisDirection[] d() {
            return new EnumAxisDirection[]{POSITIVE, NEGATIVE};
        }

        static {
            e = EnumAxisDirection.d();
        }
    }

    public static final class EnumDirectionLimit
    extends Enum<EnumDirectionLimit>
    implements Iterable<EnumDirection>,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumDirectionLimit HORIZONTAL = new EnumDirectionLimit(new EnumDirection[]{NORTH, EAST, SOUTH, WEST}, new EnumAxis[]{EnumAxis.X, EnumAxis.Z});
        public static final /* enum */ EnumDirectionLimit VERTICAL = new EnumDirectionLimit(new EnumDirection[]{UP, DOWN}, new EnumAxis[]{EnumAxis.Y});
        private final EnumDirection[] faces;
        private final EnumAxis[] axis;
        private static final /* synthetic */ EnumDirectionLimit[] e;

        public static EnumDirectionLimit[] values() {
            return (EnumDirectionLimit[])e.clone();
        }

        public static EnumDirectionLimit valueOf(String var0) {
            return Enum.valueOf(EnumDirectionLimit.class, var0);
        }

        private EnumDirectionLimit(EnumDirection[] var2, EnumAxis[] var3) {
            this.faces = var2;
            this.axis = var3;
        }

        public EnumDirection getRandomDirection(RandomSource var0) {
            return SystemUtils.getRandom(this.faces, var0);
        }

        public EnumAxis getRandomAxis(RandomSource var0) {
            return SystemUtils.getRandom(this.axis, var0);
        }

        @Override
        public boolean test(@Nullable EnumDirection var0) {
            return var0 != null && var0.getAxis().getPlane() == this;
        }

        @Override
        public Iterator<EnumDirection> iterator() {
            return Iterators.forArray((Object[])this.faces);
        }

        public Stream<EnumDirection> stream() {
            return Arrays.stream(this.faces);
        }

        public List<EnumDirection> shuffledCopy(RandomSource var0) {
            return SystemUtils.shuffledCopy(this.faces, var0);
        }

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((EnumDirection)object);
        }

        private static /* synthetic */ EnumDirectionLimit[] b() {
            return new EnumDirectionLimit[]{HORIZONTAL, VERTICAL};
        }

        static {
            e = EnumDirectionLimit.b();
        }
    }
}

