/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.coordinates.ArgumentVectorPosition;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.coordinates.VectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.level.World;

public class ArgumentPosition
implements ArgumentType<IVectorPosition> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0 0", "~ ~ ~", "^ ^ ^", "^1 ^ ^-5", "~0.5 ~1 ~-5");
    public static final SimpleCommandExceptionType ERROR_NOT_LOADED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.pos.unloaded"));
    public static final SimpleCommandExceptionType ERROR_OUT_OF_WORLD = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.pos.outofworld"));
    public static final SimpleCommandExceptionType ERROR_OUT_OF_BOUNDS = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.pos.outofbounds"));

    public static ArgumentPosition blockPos() {
        return new ArgumentPosition();
    }

    public static BlockPosition getLoadedBlockPos(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        BlockPosition var2 = ((IVectorPosition)var0.getArgument(var1, IVectorPosition.class)).getBlockPos((CommandListenerWrapper)var0.getSource());
        if (!((CommandListenerWrapper)var0.getSource()).getLevel().hasChunkAt(var2)) {
            throw ERROR_NOT_LOADED.create();
        }
        if (!((CommandListenerWrapper)var0.getSource()).getLevel().isInWorldBounds(var2)) {
            throw ERROR_OUT_OF_WORLD.create();
        }
        return var2;
    }

    public static BlockPosition getSpawnablePos(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        BlockPosition var2 = ((IVectorPosition)var0.getArgument(var1, IVectorPosition.class)).getBlockPos((CommandListenerWrapper)var0.getSource());
        if (!World.isInSpawnableBounds(var2)) {
            throw ERROR_OUT_OF_BOUNDS.create();
        }
        return var2;
    }

    public IVectorPosition parse(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '^') {
            return ArgumentVectorPosition.parse(var0);
        }
        return VectorPosition.parseInt(var0);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        if (var0.getSource() instanceof ICompletionProvider) {
            String var2 = var1.getRemaining();
            Collection<ICompletionProvider.b> var3 = !var2.isEmpty() && var2.charAt(0) == '^' ? Collections.singleton(ICompletionProvider.b.DEFAULT_LOCAL) : ((ICompletionProvider)var0.getSource()).getRelevantCoordinates();
            return ICompletionProvider.suggestCoordinates(var2, var3, var1, CommandDispatcher.createValidator(this::parse));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

