/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix3f;
import com.mojang.math.PointGroupS;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPropertyJigsawOrientation;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.INamable;

public final class PointGroupO
extends Enum<PointGroupO>
implements INamable {
    public static final /* enum */ PointGroupO IDENTITY = new PointGroupO("identity", PointGroupS.P123, false, false, false);
    public static final /* enum */ PointGroupO ROT_180_FACE_XY = new PointGroupO("rot_180_face_xy", PointGroupS.P123, true, true, false);
    public static final /* enum */ PointGroupO ROT_180_FACE_XZ = new PointGroupO("rot_180_face_xz", PointGroupS.P123, true, false, true);
    public static final /* enum */ PointGroupO ROT_180_FACE_YZ = new PointGroupO("rot_180_face_yz", PointGroupS.P123, false, true, true);
    public static final /* enum */ PointGroupO ROT_120_NNN = new PointGroupO("rot_120_nnn", PointGroupS.P231, false, false, false);
    public static final /* enum */ PointGroupO ROT_120_NNP = new PointGroupO("rot_120_nnp", PointGroupS.P312, true, false, true);
    public static final /* enum */ PointGroupO ROT_120_NPN = new PointGroupO("rot_120_npn", PointGroupS.P312, false, true, true);
    public static final /* enum */ PointGroupO ROT_120_NPP = new PointGroupO("rot_120_npp", PointGroupS.P231, true, false, true);
    public static final /* enum */ PointGroupO ROT_120_PNN = new PointGroupO("rot_120_pnn", PointGroupS.P312, true, true, false);
    public static final /* enum */ PointGroupO ROT_120_PNP = new PointGroupO("rot_120_pnp", PointGroupS.P231, true, true, false);
    public static final /* enum */ PointGroupO ROT_120_PPN = new PointGroupO("rot_120_ppn", PointGroupS.P231, false, true, true);
    public static final /* enum */ PointGroupO ROT_120_PPP = new PointGroupO("rot_120_ppp", PointGroupS.P312, false, false, false);
    public static final /* enum */ PointGroupO ROT_180_EDGE_XY_NEG = new PointGroupO("rot_180_edge_xy_neg", PointGroupS.P213, true, true, true);
    public static final /* enum */ PointGroupO ROT_180_EDGE_XY_POS = new PointGroupO("rot_180_edge_xy_pos", PointGroupS.P213, false, false, true);
    public static final /* enum */ PointGroupO ROT_180_EDGE_XZ_NEG = new PointGroupO("rot_180_edge_xz_neg", PointGroupS.P321, true, true, true);
    public static final /* enum */ PointGroupO ROT_180_EDGE_XZ_POS = new PointGroupO("rot_180_edge_xz_pos", PointGroupS.P321, false, true, false);
    public static final /* enum */ PointGroupO ROT_180_EDGE_YZ_NEG = new PointGroupO("rot_180_edge_yz_neg", PointGroupS.P132, true, true, true);
    public static final /* enum */ PointGroupO ROT_180_EDGE_YZ_POS = new PointGroupO("rot_180_edge_yz_pos", PointGroupS.P132, true, false, false);
    public static final /* enum */ PointGroupO ROT_90_X_NEG = new PointGroupO("rot_90_x_neg", PointGroupS.P132, false, false, true);
    public static final /* enum */ PointGroupO ROT_90_X_POS = new PointGroupO("rot_90_x_pos", PointGroupS.P132, false, true, false);
    public static final /* enum */ PointGroupO ROT_90_Y_NEG = new PointGroupO("rot_90_y_neg", PointGroupS.P321, true, false, false);
    public static final /* enum */ PointGroupO ROT_90_Y_POS = new PointGroupO("rot_90_y_pos", PointGroupS.P321, false, false, true);
    public static final /* enum */ PointGroupO ROT_90_Z_NEG = new PointGroupO("rot_90_z_neg", PointGroupS.P213, false, true, false);
    public static final /* enum */ PointGroupO ROT_90_Z_POS = new PointGroupO("rot_90_z_pos", PointGroupS.P213, true, false, false);
    public static final /* enum */ PointGroupO INVERSION = new PointGroupO("inversion", PointGroupS.P123, true, true, true);
    public static final /* enum */ PointGroupO INVERT_X = new PointGroupO("invert_x", PointGroupS.P123, true, false, false);
    public static final /* enum */ PointGroupO INVERT_Y = new PointGroupO("invert_y", PointGroupS.P123, false, true, false);
    public static final /* enum */ PointGroupO INVERT_Z = new PointGroupO("invert_z", PointGroupS.P123, false, false, true);
    public static final /* enum */ PointGroupO ROT_60_REF_NNN = new PointGroupO("rot_60_ref_nnn", PointGroupS.P312, true, true, true);
    public static final /* enum */ PointGroupO ROT_60_REF_NNP = new PointGroupO("rot_60_ref_nnp", PointGroupS.P231, true, false, false);
    public static final /* enum */ PointGroupO ROT_60_REF_NPN = new PointGroupO("rot_60_ref_npn", PointGroupS.P231, false, false, true);
    public static final /* enum */ PointGroupO ROT_60_REF_NPP = new PointGroupO("rot_60_ref_npp", PointGroupS.P312, false, false, true);
    public static final /* enum */ PointGroupO ROT_60_REF_PNN = new PointGroupO("rot_60_ref_pnn", PointGroupS.P231, false, true, false);
    public static final /* enum */ PointGroupO ROT_60_REF_PNP = new PointGroupO("rot_60_ref_pnp", PointGroupS.P312, true, false, false);
    public static final /* enum */ PointGroupO ROT_60_REF_PPN = new PointGroupO("rot_60_ref_ppn", PointGroupS.P312, false, true, false);
    public static final /* enum */ PointGroupO ROT_60_REF_PPP = new PointGroupO("rot_60_ref_ppp", PointGroupS.P231, true, true, true);
    public static final /* enum */ PointGroupO SWAP_XY = new PointGroupO("swap_xy", PointGroupS.P213, false, false, false);
    public static final /* enum */ PointGroupO SWAP_YZ = new PointGroupO("swap_yz", PointGroupS.P132, false, false, false);
    public static final /* enum */ PointGroupO SWAP_XZ = new PointGroupO("swap_xz", PointGroupS.P321, false, false, false);
    public static final /* enum */ PointGroupO SWAP_NEG_XY = new PointGroupO("swap_neg_xy", PointGroupS.P213, true, true, false);
    public static final /* enum */ PointGroupO SWAP_NEG_YZ = new PointGroupO("swap_neg_yz", PointGroupS.P132, false, true, true);
    public static final /* enum */ PointGroupO SWAP_NEG_XZ = new PointGroupO("swap_neg_xz", PointGroupS.P321, true, false, true);
    public static final /* enum */ PointGroupO ROT_90_REF_X_NEG = new PointGroupO("rot_90_ref_x_neg", PointGroupS.P132, true, false, true);
    public static final /* enum */ PointGroupO ROT_90_REF_X_POS = new PointGroupO("rot_90_ref_x_pos", PointGroupS.P132, true, true, false);
    public static final /* enum */ PointGroupO ROT_90_REF_Y_NEG = new PointGroupO("rot_90_ref_y_neg", PointGroupS.P321, true, true, false);
    public static final /* enum */ PointGroupO ROT_90_REF_Y_POS = new PointGroupO("rot_90_ref_y_pos", PointGroupS.P321, false, true, true);
    public static final /* enum */ PointGroupO ROT_90_REF_Z_NEG = new PointGroupO("rot_90_ref_z_neg", PointGroupS.P213, false, true, true);
    public static final /* enum */ PointGroupO ROT_90_REF_Z_POS = new PointGroupO("rot_90_ref_z_pos", PointGroupS.P213, true, false, true);
    private final Matrix3f transformation;
    private final String name;
    @Nullable
    private Map<EnumDirection, EnumDirection> rotatedDirections;
    private final boolean invertX;
    private final boolean invertY;
    private final boolean invertZ;
    private final PointGroupS permutation;
    private static final PointGroupO[][] cayleyTable;
    private static final PointGroupO[] inverseTable;
    private static final /* synthetic */ PointGroupO[] ag;

    public static PointGroupO[] values() {
        return (PointGroupO[])ag.clone();
    }

    public static PointGroupO valueOf(String var0) {
        return Enum.valueOf(PointGroupO.class, var0);
    }

    private PointGroupO(String var2, PointGroupS var3, boolean var4, boolean var5, boolean var6) {
        this.name = var2;
        this.invertX = var4;
        this.invertY = var5;
        this.invertZ = var6;
        this.permutation = var3;
        this.transformation = new Matrix3f();
        this.transformation.m00 = var4 ? -1.0f : 1.0f;
        this.transformation.m11 = var5 ? -1.0f : 1.0f;
        this.transformation.m22 = var6 ? -1.0f : 1.0f;
        this.transformation.mul(var3.transformation());
    }

    private BooleanList packInversions() {
        return new BooleanArrayList(new boolean[]{this.invertX, this.invertY, this.invertZ});
    }

    public PointGroupO compose(PointGroupO var0) {
        return cayleyTable[this.ordinal()][var0.ordinal()];
    }

    public PointGroupO inverse() {
        return inverseTable[this.ordinal()];
    }

    public Matrix3f transformation() {
        return this.transformation.copy();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public EnumDirection rotate(EnumDirection var0) {
        if (this.rotatedDirections == null) {
            this.rotatedDirections = Maps.newEnumMap(EnumDirection.class);
            for (EnumDirection var4 : EnumDirection.values()) {
                EnumDirection.EnumAxis var5 = var4.getAxis();
                EnumDirection.EnumAxisDirection var6 = var4.getAxisDirection();
                EnumDirection.EnumAxis var7 = EnumDirection.EnumAxis.values()[this.permutation.permutation(var5.ordinal())];
                EnumDirection.EnumAxisDirection var8 = this.inverts(var7) ? var6.opposite() : var6;
                EnumDirection var9 = EnumDirection.fromAxisAndDirection(var7, var8);
                this.rotatedDirections.put(var4, var9);
            }
        }
        return this.rotatedDirections.get(var0);
    }

    public boolean inverts(EnumDirection.EnumAxis var0) {
        switch (var0) {
            case X: {
                return this.invertX;
            }
            case Y: {
                return this.invertY;
            }
        }
        return this.invertZ;
    }

    public BlockPropertyJigsawOrientation rotate(BlockPropertyJigsawOrientation var0) {
        return BlockPropertyJigsawOrientation.fromFrontAndTop(this.rotate(var0.front()), this.rotate(var0.top()));
    }

    private static /* synthetic */ PointGroupO[] e() {
        return new PointGroupO[]{IDENTITY, ROT_180_FACE_XY, ROT_180_FACE_XZ, ROT_180_FACE_YZ, ROT_120_NNN, ROT_120_NNP, ROT_120_NPN, ROT_120_NPP, ROT_120_PNN, ROT_120_PNP, ROT_120_PPN, ROT_120_PPP, ROT_180_EDGE_XY_NEG, ROT_180_EDGE_XY_POS, ROT_180_EDGE_XZ_NEG, ROT_180_EDGE_XZ_POS, ROT_180_EDGE_YZ_NEG, ROT_180_EDGE_YZ_POS, ROT_90_X_NEG, ROT_90_X_POS, ROT_90_Y_NEG, ROT_90_Y_POS, ROT_90_Z_NEG, ROT_90_Z_POS, INVERSION, INVERT_X, INVERT_Y, INVERT_Z, ROT_60_REF_NNN, ROT_60_REF_NNP, ROT_60_REF_NPN, ROT_60_REF_NPP, ROT_60_REF_PNN, ROT_60_REF_PNP, ROT_60_REF_PPN, ROT_60_REF_PPP, SWAP_XY, SWAP_YZ, SWAP_XZ, SWAP_NEG_XY, SWAP_NEG_YZ, SWAP_NEG_XZ, ROT_90_REF_X_NEG, ROT_90_REF_X_POS, ROT_90_REF_Y_NEG, ROT_90_REF_Y_POS, ROT_90_REF_Z_NEG, ROT_90_REF_Z_POS};
    }

    static {
        ag = PointGroupO.e();
        cayleyTable = SystemUtils.make(new PointGroupO[PointGroupO.values().length][PointGroupO.values().length], var02 -> {
            Map<Pair, PointGroupO> var1 = Arrays.stream(PointGroupO.values()).collect(Collectors.toMap(var0 -> Pair.of((Object)((Object)var0.permutation), (Object)var0.packInversions()), var0 -> var0));
            for (PointGroupO var5 : PointGroupO.values()) {
                for (PointGroupO var9 : PointGroupO.values()) {
                    BooleanList var10 = var5.packInversions();
                    BooleanList var11 = var9.packInversions();
                    PointGroupS var12 = var9.permutation.compose(var5.permutation);
                    BooleanArrayList var13 = new BooleanArrayList(3);
                    for (int var14 = 0; var14 < 3; ++var14) {
                        var13.add(var10.getBoolean(var14) ^ var11.getBoolean(var5.permutation.permutation(var14)));
                    }
                    var02[var5.ordinal()][var9.ordinal()] = var1.get(Pair.of((Object)((Object)var12), (Object)var13));
                }
            }
        });
        inverseTable = (PointGroupO[])Arrays.stream(PointGroupO.values()).map(var0 -> Arrays.stream(PointGroupO.values()).filter(var1 -> var0.compose((PointGroupO)var1) == IDENTITY).findAny().get()).toArray(PointGroupO[]::new);
    }
}

