/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.JsonRegistry;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.ScoreboardValue;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class NumberProviders {
    public static final LootNumberProviderType CONSTANT = NumberProviders.register("constant", new ConstantValue.b());
    public static final LootNumberProviderType UNIFORM = NumberProviders.register("uniform", new UniformGenerator.a());
    public static final LootNumberProviderType BINOMIAL = NumberProviders.register("binomial", new BinomialDistributionGenerator.a());
    public static final LootNumberProviderType SCORE = NumberProviders.register("score", new ScoreboardValue.a());

    private static LootNumberProviderType register(String var0, LootSerializer<? extends NumberProvider> var1) {
        return IRegistry.register(IRegistry.LOOT_NUMBER_PROVIDER_TYPE, new MinecraftKey(var0), new LootNumberProviderType(var1));
    }

    public static Object createGsonAdapter() {
        return JsonRegistry.builder(IRegistry.LOOT_NUMBER_PROVIDER_TYPE, "provider", "type", NumberProvider::getType).withInlineSerializer(CONSTANT, new ConstantValue.a()).withDefaultType(UNIFORM).build();
    }
}

