/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public final class BinomialDistributionGenerator
implements NumberProvider {
    final NumberProvider n;
    final NumberProvider p;

    BinomialDistributionGenerator(NumberProvider var0, NumberProvider var1) {
        this.n = var0;
        this.p = var1;
    }

    @Override
    public LootNumberProviderType getType() {
        return NumberProviders.BINOMIAL;
    }

    @Override
    public int getInt(LootTableInfo var0) {
        int var1 = this.n.getInt(var0);
        float var2 = this.p.getFloat(var0);
        RandomSource var3 = var0.getRandom();
        int var4 = 0;
        for (int var5 = 0; var5 < var1; ++var5) {
            if (!(var3.nextFloat() < var2)) continue;
            ++var4;
        }
        return var4;
    }

    @Override
    public float getFloat(LootTableInfo var0) {
        return this.getInt(var0);
    }

    public static BinomialDistributionGenerator binomial(int var0, float var1) {
        return new BinomialDistributionGenerator(ConstantValue.exactly(var0), ConstantValue.exactly(var1));
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return Sets.union(this.n.getReferencedContextParams(), this.p.getReferencedContextParams());
    }

    public static class a
    implements LootSerializer<BinomialDistributionGenerator> {
        @Override
        public BinomialDistributionGenerator deserialize(JsonObject var0, JsonDeserializationContext var1) {
            NumberProvider var2 = ChatDeserializer.getAsObject(var0, "n", var1, NumberProvider.class);
            NumberProvider var3 = ChatDeserializer.getAsObject(var0, "p", var1, NumberProvider.class);
            return new BinomialDistributionGenerator(var2, var3);
        }

        @Override
        public void serialize(JsonObject var0, BinomialDistributionGenerator var1, JsonSerializationContext var2) {
            var0.add("n", var2.serialize((Object)var1.n));
            var0.add("p", var2.serialize((Object)var1.p));
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

