/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetInstrumentFunction
extends LootItemFunctionConditional {
    final TagKey<Instrument> options;

    SetInstrumentFunction(LootItemCondition[] var0, TagKey<Instrument> var1) {
        super(var0);
        this.options = var1;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_INSTRUMENT;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        InstrumentItem.setRandom(var0, this.options, var1.getRandom());
        return var0;
    }

    public static LootItemFunctionConditional.a<?> setInstrumentOptions(TagKey<Instrument> var0) {
        return SetInstrumentFunction.simpleBuilder(var1 -> new SetInstrumentFunction((LootItemCondition[])var1, var0));
    }

    public static class a
    extends LootItemFunctionConditional.c<SetInstrumentFunction> {
        @Override
        public void serialize(JsonObject var0, SetInstrumentFunction var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.addProperty("options", "#" + var1.options.location());
        }

        @Override
        public SetInstrumentFunction deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            String var3 = ChatDeserializer.getAsString(var0, "options");
            if (!var3.startsWith("#")) {
                throw new JsonSyntaxException("Inline tag value not supported: " + var3);
            }
            return new SetInstrumentFunction(var2, TagKey.create(IRegistry.INSTRUMENT_REGISTRY, new MinecraftKey(var3.substring(1))));
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

