/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootItemFunctionSetCount
extends LootItemFunctionConditional {
    final NumberProvider value;
    final boolean add;

    LootItemFunctionSetCount(LootItemCondition[] var0, NumberProvider var1, boolean var2) {
        super(var0);
        this.value = var1;
        this.add = var2;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_COUNT;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.value.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        int var2 = this.add ? var0.getCount() : 0;
        var0.setCount(MathHelper.clamp(var2 + this.value.getInt(var1), 0, var0.getMaxStackSize()));
        return var0;
    }

    public static LootItemFunctionConditional.a<?> setCount(NumberProvider var0) {
        return LootItemFunctionSetCount.simpleBuilder(var1 -> new LootItemFunctionSetCount((LootItemCondition[])var1, var0, false));
    }

    public static LootItemFunctionConditional.a<?> setCount(NumberProvider var0, boolean var1) {
        return LootItemFunctionSetCount.simpleBuilder(var2 -> new LootItemFunctionSetCount((LootItemCondition[])var2, var0, var1));
    }

    public static class a
    extends LootItemFunctionConditional.c<LootItemFunctionSetCount> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionSetCount var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.add("count", var2.serialize((Object)var1.value));
            var0.addProperty("add", Boolean.valueOf(var1.add));
        }

        @Override
        public LootItemFunctionSetCount deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            NumberProvider var3 = ChatDeserializer.getAsObject(var0, "count", var1, NumberProvider.class);
            boolean var4 = ChatDeserializer.getAsBoolean(var0, "add", false);
            return new LootItemFunctionSetCount(var2, var3, var4);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

