/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionSetContents
extends LootItemFunctionConditional {
    final List<LootEntryAbstract> entries;
    final TileEntityTypes<?> type;

    LootItemFunctionSetContents(LootItemCondition[] var0, TileEntityTypes<?> var1, List<LootEntryAbstract> var2) {
        super(var0);
        this.type = var1;
        this.entries = ImmutableList.copyOf(var2);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_CONTENTS;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        if (var0.isEmpty()) {
            return var0;
        }
        NonNullList<ItemStack> var2 = NonNullList.create();
        this.entries.forEach(var22 -> var22.expand(var1, var2 -> var2.createItemStack(LootTable.createStackSplitter(var2::add), var1)));
        NBTTagCompound var3 = new NBTTagCompound();
        ContainerUtil.saveAllItems(var3, var2);
        NBTTagCompound var4 = ItemBlock.getBlockEntityData(var0);
        if (var4 == null) {
            var4 = var3;
        } else {
            var4.merge(var3);
        }
        ItemBlock.setBlockEntityData(var0, this.type, var4);
        return var0;
    }

    @Override
    public void validate(LootCollector var0) {
        super.validate(var0);
        for (int var1 = 0; var1 < this.entries.size(); ++var1) {
            this.entries.get(var1).validate(var0.forChild(".entry[" + var1 + "]"));
        }
    }

    public static a setContents(TileEntityTypes<?> var0) {
        return new a(var0);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final List<LootEntryAbstract> entries = Lists.newArrayList();
        private final TileEntityTypes<?> type;

        public a(TileEntityTypes<?> var0) {
            this.type = var0;
        }

        @Override
        protected a getThis() {
            return this;
        }

        public a withEntry(LootEntryAbstract.a<?> var0) {
            this.entries.add(var0.build());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionSetContents(this.getConditions(), this.type, this.entries);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootItemFunctionSetContents> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionSetContents var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.addProperty("type", IRegistry.BLOCK_ENTITY_TYPE.getKey(var1.type).toString());
            var0.add("entries", var2.serialize(var1.entries));
        }

        @Override
        public LootItemFunctionSetContents deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            LootEntryAbstract[] var3 = ChatDeserializer.getAsObject(var0, "entries", var1, LootEntryAbstract[].class);
            MinecraftKey var4 = new MinecraftKey(ChatDeserializer.getAsString(var0, "type"));
            TileEntityTypes<?> var5 = IRegistry.BLOCK_ENTITY_TYPE.getOptional(var4).orElseThrow(() -> new JsonSyntaxException("Unknown block entity type id '" + var4 + "'"));
            return new LootItemFunctionSetContents(var2, var5, Arrays.asList(var3));
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

