/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootItemFunctionSetAttribute
extends LootItemFunctionConditional {
    final List<b> modifiers;

    LootItemFunctionSetAttribute(LootItemCondition[] var0, List<b> var1) {
        super(var0);
        this.modifiers = ImmutableList.copyOf(var1);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_ATTRIBUTES;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return (Set)this.modifiers.stream().flatMap(var0 -> var0.amount.getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        RandomSource var2 = var1.getRandom();
        for (b var4 : this.modifiers) {
            UUID var5 = var4.id;
            if (var5 == null) {
                var5 = UUID.randomUUID();
            }
            EnumItemSlot var6 = SystemUtils.getRandom(var4.slots, var2);
            var0.addAttributeModifier(var4.attribute, new AttributeModifier(var5, var4.name, (double)var4.amount.getFloat(var1), var4.operation), var6);
        }
        return var0;
    }

    public static c modifier(String var0, AttributeBase var1, AttributeModifier.Operation var2, NumberProvider var3) {
        return new c(var0, var1, var2, var3);
    }

    public static a setAttributes() {
        return new a();
    }

    static class b {
        final String name;
        final AttributeBase attribute;
        final AttributeModifier.Operation operation;
        final NumberProvider amount;
        @Nullable
        final UUID id;
        final EnumItemSlot[] slots;

        b(String var0, AttributeBase var1, AttributeModifier.Operation var2, NumberProvider var3, EnumItemSlot[] var4, @Nullable UUID var5) {
            this.name = var0;
            this.attribute = var1;
            this.operation = var2;
            this.amount = var3;
            this.id = var5;
            this.slots = var4;
        }

        public JsonObject serialize(JsonSerializationContext var0) {
            JsonObject var1 = new JsonObject();
            var1.addProperty("name", this.name);
            var1.addProperty("attribute", IRegistry.ATTRIBUTE.getKey(this.attribute).toString());
            var1.addProperty("operation", b.operationToString(this.operation));
            var1.add("amount", var0.serialize((Object)this.amount));
            if (this.id != null) {
                var1.addProperty("id", this.id.toString());
            }
            if (this.slots.length == 1) {
                var1.addProperty("slot", this.slots[0].getName());
            } else {
                JsonArray var2 = new JsonArray();
                for (EnumItemSlot var6 : this.slots) {
                    var2.add((JsonElement)new JsonPrimitive(var6.getName()));
                }
                var1.add("slot", (JsonElement)var2);
            }
            return var1;
        }

        public static b deserialize(JsonObject var0, JsonDeserializationContext var1) {
            Object var9;
            EnumItemSlot[] var7;
            String var2 = ChatDeserializer.getAsString(var0, "name");
            MinecraftKey var3 = new MinecraftKey(ChatDeserializer.getAsString(var0, "attribute"));
            AttributeBase var4 = IRegistry.ATTRIBUTE.get(var3);
            if (var4 == null) {
                throw new JsonSyntaxException("Unknown attribute: " + var3);
            }
            AttributeModifier.Operation var5 = b.operationFromString(ChatDeserializer.getAsString(var0, "operation"));
            NumberProvider var6 = ChatDeserializer.getAsObject(var0, "amount", var1, NumberProvider.class);
            UUID var8 = null;
            if (ChatDeserializer.isStringValue(var0, "slot")) {
                var7 = new EnumItemSlot[]{EnumItemSlot.byName(ChatDeserializer.getAsString(var0, "slot"))};
            } else if (ChatDeserializer.isArrayNode(var0, "slot")) {
                var9 = ChatDeserializer.getAsJsonArray(var0, "slot");
                var7 = new EnumItemSlot[var9.size()];
                int var10 = 0;
                for (JsonElement var12 : var9) {
                    var7[var10++] = EnumItemSlot.byName(ChatDeserializer.convertToString(var12, "slot"));
                }
                if (var7.length == 0) {
                    throw new JsonSyntaxException("Invalid attribute modifier slot; must contain at least one entry.");
                }
            } else {
                throw new JsonSyntaxException("Invalid or missing attribute modifier slot; must be either string or array of strings.");
            }
            if (var0.has("id")) {
                var9 = ChatDeserializer.getAsString(var0, "id");
                try {
                    var8 = UUID.fromString((String)var9);
                }
                catch (IllegalArgumentException var10) {
                    throw new JsonSyntaxException("Invalid attribute modifier id '" + (String)var9 + "' (must be UUID format, with dashes)");
                }
            }
            return new b(var2, var4, var5, var6, var7, var8);
        }

        private static String operationToString(AttributeModifier.Operation var0) {
            switch (var0) {
                case ADDITION: {
                    return "addition";
                }
                case MULTIPLY_BASE: {
                    return "multiply_base";
                }
                case MULTIPLY_TOTAL: {
                    return "multiply_total";
                }
            }
            throw new IllegalArgumentException("Unknown operation " + var0);
        }

        private static AttributeModifier.Operation operationFromString(String var0) {
            switch (var0) {
                case "addition": {
                    return AttributeModifier.Operation.ADDITION;
                }
                case "multiply_base": {
                    return AttributeModifier.Operation.MULTIPLY_BASE;
                }
                case "multiply_total": {
                    return AttributeModifier.Operation.MULTIPLY_TOTAL;
                }
            }
            throw new JsonSyntaxException("Unknown attribute modifier operation " + var0);
        }
    }

    public static class c {
        private final String name;
        private final AttributeBase attribute;
        private final AttributeModifier.Operation operation;
        private final NumberProvider amount;
        @Nullable
        private UUID id;
        private final Set<EnumItemSlot> slots = EnumSet.noneOf(EnumItemSlot.class);

        public c(String var0, AttributeBase var1, AttributeModifier.Operation var2, NumberProvider var3) {
            this.name = var0;
            this.attribute = var1;
            this.operation = var2;
            this.amount = var3;
        }

        public c forSlot(EnumItemSlot var0) {
            this.slots.add(var0);
            return this;
        }

        public c withUuid(UUID var0) {
            this.id = var0;
            return this;
        }

        public b build() {
            return new b(this.name, this.attribute, this.operation, this.amount, this.slots.toArray(new EnumItemSlot[0]), this.id);
        }
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final List<b> modifiers = Lists.newArrayList();

        @Override
        protected a getThis() {
            return this;
        }

        public a withModifier(c var0) {
            this.modifiers.add(var0.build());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionSetAttribute(this.getConditions(), this.modifiers);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    public static class d
    extends LootItemFunctionConditional.c<LootItemFunctionSetAttribute> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionSetAttribute var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            JsonArray var3 = new JsonArray();
            for (b var5 : var1.modifiers) {
                var3.add((JsonElement)var5.serialize(var2));
            }
            var0.add("modifiers", (JsonElement)var3);
        }

        @Override
        public LootItemFunctionSetAttribute deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            JsonArray var3 = ChatDeserializer.getAsJsonArray(var0, "modifiers");
            ArrayList var4 = Lists.newArrayListWithExpectedSize((int)var3.size());
            for (JsonElement var6 : var3) {
                var4.add(b.deserialize(ChatDeserializer.convertToJsonObject(var6, "modifier"), var1));
            }
            if (var4.isEmpty()) {
                throw new JsonSyntaxException("Invalid attribute modifiers array; cannot be empty");
            }
            return new LootItemFunctionSetAttribute(var2, var4);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

