/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.logging.LogUtils;
import java.util.Locale;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class LootItemFunctionExplorationMap
extends LootItemFunctionConditional {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final TagKey<Structure> DEFAULT_DESTINATION = StructureTags.ON_TREASURE_MAPS;
    public static final String DEFAULT_DECORATION_NAME = "mansion";
    public static final MapIcon.Type DEFAULT_DECORATION = MapIcon.Type.MANSION;
    public static final byte DEFAULT_ZOOM = 2;
    public static final int DEFAULT_SEARCH_RADIUS = 50;
    public static final boolean DEFAULT_SKIP_EXISTING = true;
    final TagKey<Structure> destination;
    final MapIcon.Type mapDecoration;
    final byte zoom;
    final int searchRadius;
    final boolean skipKnownStructures;

    LootItemFunctionExplorationMap(LootItemCondition[] var0, TagKey<Structure> var1, MapIcon.Type var2, byte var3, int var4, boolean var5) {
        super(var0);
        this.destination = var1;
        this.mapDecoration = var2;
        this.zoom = var3;
        this.searchRadius = var4;
        this.skipKnownStructures = var5;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.EXPLORATION_MAP;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.ORIGIN);
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        WorldServer var3;
        BlockPosition var4;
        if (!var0.is(Items.MAP)) {
            return var0;
        }
        Vec3D var2 = var1.getParamOrNull(LootContextParameters.ORIGIN);
        if (var2 != null && (var4 = (var3 = var1.getLevel()).findNearestMapStructure(this.destination, new BlockPosition(var2), this.searchRadius, this.skipKnownStructures)) != null) {
            ItemStack var5 = ItemWorldMap.create(var3, var4.getX(), var4.getZ(), this.zoom, true, true);
            ItemWorldMap.renderBiomePreviewMap(var3, var5);
            WorldMap.addTargetDecoration(var5, var4, "+", this.mapDecoration);
            return var5;
        }
        return var0;
    }

    public static a makeExplorationMap() {
        return new a();
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private TagKey<Structure> destination = DEFAULT_DESTINATION;
        private MapIcon.Type mapDecoration = DEFAULT_DECORATION;
        private byte zoom = (byte)2;
        private int searchRadius = 50;
        private boolean skipKnownStructures = true;

        @Override
        protected a getThis() {
            return this;
        }

        public a setDestination(TagKey<Structure> var0) {
            this.destination = var0;
            return this;
        }

        public a setMapDecoration(MapIcon.Type var0) {
            this.mapDecoration = var0;
            return this;
        }

        public a setZoom(byte var0) {
            this.zoom = var0;
            return this;
        }

        public a setSearchRadius(int var0) {
            this.searchRadius = var0;
            return this;
        }

        public a setSkipKnownStructures(boolean var0) {
            this.skipKnownStructures = var0;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionExplorationMap(this.getConditions(), this.destination, this.mapDecoration, this.zoom, this.searchRadius, this.skipKnownStructures);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootItemFunctionExplorationMap> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionExplorationMap var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            if (!var1.destination.equals(DEFAULT_DESTINATION)) {
                var0.addProperty("destination", var1.destination.location().toString());
            }
            if (var1.mapDecoration != DEFAULT_DECORATION) {
                var0.add("decoration", var2.serialize((Object)var1.mapDecoration.toString().toLowerCase(Locale.ROOT)));
            }
            if (var1.zoom != 2) {
                var0.addProperty("zoom", (Number)var1.zoom);
            }
            if (var1.searchRadius != 50) {
                var0.addProperty("search_radius", (Number)var1.searchRadius);
            }
            if (!var1.skipKnownStructures) {
                var0.addProperty("skip_existing_chunks", Boolean.valueOf(var1.skipKnownStructures));
            }
        }

        @Override
        public LootItemFunctionExplorationMap deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            TagKey<Structure> var3 = b.readStructure(var0);
            String var4 = var0.has("decoration") ? ChatDeserializer.getAsString(var0, "decoration") : LootItemFunctionExplorationMap.DEFAULT_DECORATION_NAME;
            MapIcon.Type var5 = DEFAULT_DECORATION;
            try {
                var5 = MapIcon.Type.valueOf(var4.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException var6) {
                LOGGER.error("Error while parsing loot table decoration entry. Found {}. Defaulting to {}", (Object)var4, (Object)DEFAULT_DECORATION);
            }
            byte var6 = ChatDeserializer.getAsByte(var0, "zoom", (byte)2);
            int var7 = ChatDeserializer.getAsInt(var0, "search_radius", 50);
            boolean var8 = ChatDeserializer.getAsBoolean(var0, "skip_existing_chunks", true);
            return new LootItemFunctionExplorationMap(var2, var3, var5, var6, var7, var8);
        }

        private static TagKey<Structure> readStructure(JsonObject var0) {
            if (var0.has("destination")) {
                String var1 = ChatDeserializer.getAsString(var0, "destination");
                return TagKey.create(IRegistry.STRUCTURE_REGISTRY, new MinecraftKey(var1));
            }
            return DEFAULT_DESTINATION;
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

