/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootPredicateManager;
import net.minecraft.world.level.storage.loot.LootSerialization;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.slf4j.Logger;

public class LootTableRegistry
extends ResourceDataJson {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = LootSerialization.createLootTableSerializer().create();
    private Map<MinecraftKey, LootTable> tables = ImmutableMap.of();
    private final LootPredicateManager predicateManager;

    public LootTableRegistry(LootPredicateManager var0) {
        super(GSON, "loot_tables");
        this.predicateManager = var0;
    }

    public LootTable get(MinecraftKey var0) {
        return this.tables.getOrDefault(var0, LootTable.EMPTY);
    }

    @Override
    protected void apply(Map<MinecraftKey, JsonElement> var02, IResourceManager var12, GameProfilerFiller var22) {
        ImmutableMap.Builder var3 = ImmutableMap.builder();
        JsonElement var4 = var02.remove(LootTables.EMPTY);
        if (var4 != null) {
            LOGGER.warn("Datapack tried to redefine {} loot table, ignoring", (Object)LootTables.EMPTY);
        }
        var02.forEach((var1, var2) -> {
            try {
                LootTable var3 = (LootTable)GSON.fromJson(var2, LootTable.class);
                var3.put(var1, (Object)var3);
            }
            catch (Exception var3) {
                LOGGER.error("Couldn't parse loot table {}", var1, (Object)var3);
            }
        });
        var3.put((Object)LootTables.EMPTY, (Object)LootTable.EMPTY);
        ImmutableMap var5 = var3.build();
        LootCollector var6 = new LootCollector(LootContextParameterSets.ALL_PARAMS, this.predicateManager::get, arg_0 -> ((ImmutableMap)var5).get(arg_0));
        var5.forEach((var1, var2) -> LootTableRegistry.validate(var6, var1, var2));
        var6.getProblems().forEach((var0, var1) -> LOGGER.warn("Found validation problem in {}: {}", var0, var1));
        this.tables = var5;
    }

    public static void validate(LootCollector var0, MinecraftKey var1, LootTable var2) {
        var2.validate(var0.setParams(var2.getParamSet()).enterTable("{" + var1 + "}", var1));
    }

    public static JsonElement serialize(LootTable var0) {
        return GSON.toJsonTree((Object)var0);
    }

    public Set<MinecraftKey> getIds() {
        return this.tables.keySet();
    }
}

