/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;

public class LootTable {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final LootTable EMPTY = new LootTable(LootContextParameterSets.EMPTY, new LootSelector[0], new LootItemFunction[0]);
    public static final LootContextParameterSet DEFAULT_PARAM_SET = LootContextParameterSets.ALL_PARAMS;
    final LootContextParameterSet paramSet;
    final LootSelector[] pools;
    final LootItemFunction[] functions;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> compositeFunction;

    LootTable(LootContextParameterSet var0, LootSelector[] var1, LootItemFunction[] var2) {
        this.paramSet = var0;
        this.pools = var1;
        this.functions = var2;
        this.compositeFunction = LootItemFunctions.compose(var2);
    }

    public static Consumer<ItemStack> createStackSplitter(Consumer<ItemStack> var0) {
        return var1 -> {
            if (var1.getCount() < var1.getMaxStackSize()) {
                var0.accept((ItemStack)var1);
            } else {
                ItemStack var3;
                for (int var2 = var1.getCount(); var2 > 0; var2 -= var3.getCount()) {
                    var3 = var1.copy();
                    var3.setCount(Math.min(var1.getMaxStackSize(), var2));
                    var0.accept(var3);
                }
            }
        };
    }

    public void getRandomItemsRaw(LootTableInfo var0, Consumer<ItemStack> var1) {
        if (var0.addVisitedTable(this)) {
            Consumer<ItemStack> var2 = LootItemFunction.decorate(this.compositeFunction, var1, var0);
            for (LootSelector var6 : this.pools) {
                var6.addRandomItems(var2, var0);
            }
            var0.removeVisitedTable(this);
        } else {
            LOGGER.warn("Detected infinite loop in loot tables");
        }
    }

    public void getRandomItems(LootTableInfo var0, Consumer<ItemStack> var1) {
        this.getRandomItemsRaw(var0, LootTable.createStackSplitter(var1));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootTableInfo var0) {
        ObjectArrayList var1 = new ObjectArrayList();
        this.getRandomItems(var0, arg_0 -> ((ObjectArrayList)var1).add(arg_0));
        return var1;
    }

    public LootContextParameterSet getParamSet() {
        return this.paramSet;
    }

    public void validate(LootCollector var0) {
        int var1;
        for (var1 = 0; var1 < this.pools.length; ++var1) {
            this.pools[var1].validate(var0.forChild(".pools[" + var1 + "]"));
        }
        for (var1 = 0; var1 < this.functions.length; ++var1) {
            this.functions[var1].validate(var0.forChild(".functions[" + var1 + "]"));
        }
    }

    public void fill(IInventory var0, LootTableInfo var1) {
        ObjectArrayList<ItemStack> var2 = this.getRandomItems(var1);
        RandomSource var3 = var1.getRandom();
        List<Integer> var4 = this.getAvailableSlots(var0, var3);
        this.shuffleAndSplitItems(var2, var4.size(), var3);
        for (ItemStack var6 : var2) {
            if (var4.isEmpty()) {
                LOGGER.warn("Tried to over-fill a container");
                return;
            }
            if (var6.isEmpty()) {
                var0.setItem(var4.remove(var4.size() - 1), ItemStack.EMPTY);
                continue;
            }
            var0.setItem(var4.remove(var4.size() - 1), var6);
        }
    }

    private void shuffleAndSplitItems(ObjectArrayList<ItemStack> var0, int var1, RandomSource var2) {
        ArrayList var3 = Lists.newArrayList();
        Object var4 = var0.iterator();
        while (var4.hasNext()) {
            ItemStack var5 = (ItemStack)var4.next();
            if (var5.isEmpty()) {
                var4.remove();
                continue;
            }
            if (var5.getCount() <= 1) continue;
            var3.add(var5);
            var4.remove();
        }
        while (var1 - var0.size() - var3.size() > 0 && !var3.isEmpty()) {
            var4 = (ItemStack)var3.remove(MathHelper.nextInt(var2, 0, var3.size() - 1));
            int var5 = MathHelper.nextInt(var2, 1, ((ItemStack)var4).getCount() / 2);
            ItemStack var6 = ((ItemStack)var4).split(var5);
            if (((ItemStack)var4).getCount() > 1 && var2.nextBoolean()) {
                var3.add(var4);
            } else {
                var0.add(var4);
            }
            if (var6.getCount() > 1 && var2.nextBoolean()) {
                var3.add(var6);
                continue;
            }
            var0.add((Object)var6);
        }
        var0.addAll((Collection)var3);
        SystemUtils.shuffle(var0, var2);
    }

    private List<Integer> getAvailableSlots(IInventory var0, RandomSource var1) {
        ObjectArrayList var2 = new ObjectArrayList();
        for (int var3 = 0; var3 < var0.getContainerSize(); ++var3) {
            if (!var0.getItem(var3).isEmpty()) continue;
            var2.add((Object)var3);
        }
        SystemUtils.shuffle(var2, var1);
        return var2;
    }

    public static a lootTable() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a> {
        private final List<LootSelector> pools = Lists.newArrayList();
        private final List<LootItemFunction> functions = Lists.newArrayList();
        private LootContextParameterSet paramSet = DEFAULT_PARAM_SET;

        public a withPool(LootSelector.a var0) {
            this.pools.add(var0.build());
            return this;
        }

        public a setParamSet(LootContextParameterSet var0) {
            this.paramSet = var0;
            return this;
        }

        @Override
        public a apply(LootItemFunction.a var0) {
            this.functions.add(var0.build());
            return this;
        }

        @Override
        public a unwrap() {
            return this;
        }

        public LootTable build() {
            return new LootTable(this.paramSet, this.pools.toArray(new LootSelector[0]), this.functions.toArray(new LootItemFunction[0]));
        }

        @Override
        public /* synthetic */ LootItemFunctionUser unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ LootItemFunctionUser apply(LootItemFunction.a a2) {
            return this.apply(a2);
        }
    }

    public static class b
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            LootItemFunction[] var6;
            JsonObject var3 = ChatDeserializer.convertToJsonObject(var0, "loot table");
            LootSelector[] var4 = ChatDeserializer.getAsObject(var3, "pools", new LootSelector[0], var2, LootSelector[].class);
            LootContextParameterSet var5 = null;
            if (var3.has("type")) {
                var6 = ChatDeserializer.getAsString(var3, "type");
                var5 = LootContextParameterSets.get(new MinecraftKey((String)var6));
            }
            var6 = ChatDeserializer.getAsObject(var3, "functions", new LootItemFunction[0], var2, LootItemFunction[].class);
            return new LootTable(var5 != null ? var5 : LootContextParameterSets.ALL_PARAMS, var4, var6);
        }

        public JsonElement serialize(LootTable var0, Type var1, JsonSerializationContext var2) {
            JsonObject var3 = new JsonObject();
            if (var0.paramSet != DEFAULT_PARAM_SET) {
                MinecraftKey var4 = LootContextParameterSets.getKey(var0.paramSet);
                if (var4 != null) {
                    var3.addProperty("type", var4.toString());
                } else {
                    LOGGER.warn("Failed to find id for param set {}", (Object)var0.paramSet);
                }
            }
            if (var0.pools.length > 0) {
                var3.add("pools", var2.serialize((Object)var0.pools));
            }
            if (!ArrayUtils.isEmpty((Object[])var0.functions)) {
                var3.add("functions", var2.serialize((Object)var0.functions));
            }
            return var3;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((LootTable)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

