/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootSerialization;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public class LootPredicateManager
extends ResourceDataJson {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = LootSerialization.createConditionSerializer().create();
    private Map<MinecraftKey, LootItemCondition> conditions = ImmutableMap.of();

    public LootPredicateManager() {
        super(GSON, "predicates");
    }

    @Nullable
    public LootItemCondition get(MinecraftKey var0) {
        return this.conditions.get(var0);
    }

    @Override
    protected void apply(Map<MinecraftKey, JsonElement> var02, IResourceManager var12, GameProfilerFiller var22) {
        ImmutableMap.Builder var3 = ImmutableMap.builder();
        var02.forEach((var1, var2) -> {
            try {
                if (var2.isJsonArray()) {
                    LootItemCondition[] var3 = (LootItemCondition[])GSON.fromJson(var2, LootItemCondition[].class);
                    var3.put(var1, (Object)new a(var3));
                } else {
                    LootItemCondition var3 = (LootItemCondition)GSON.fromJson(var2, LootItemCondition.class);
                    var3.put(var1, (Object)var3);
                }
            }
            catch (Exception var3) {
                LOGGER.error("Couldn't parse loot table {}", var1, (Object)var3);
            }
        });
        ImmutableMap var4 = var3.build();
        LootCollector var5 = new LootCollector(LootContextParameterSets.ALL_PARAMS, ((Map)var4)::get, var0 -> null);
        var4.forEach((var1, var2) -> var2.validate(var5.enterCondition("{" + var1 + "}", (MinecraftKey)var1)));
        var5.getProblems().forEach((var0, var1) -> LOGGER.warn("Found validation problem in {}: {}", var0, var1));
        this.conditions = var4;
    }

    public Set<MinecraftKey> getKeys() {
        return Collections.unmodifiableSet(this.conditions.keySet());
    }

    static class a
    implements LootItemCondition {
        private final LootItemCondition[] terms;
        private final Predicate<LootTableInfo> composedPredicate;

        a(LootItemCondition[] var0) {
            this.terms = var0;
            this.composedPredicate = LootItemConditions.andConditions(var0);
        }

        @Override
        public final boolean test(LootTableInfo var0) {
            return this.composedPredicate.test(var0);
        }

        @Override
        public void validate(LootCollector var0) {
            LootItemCondition.super.validate(var0);
            for (int var1 = 0; var1 < this.terms.length; ++var1) {
                this.terms[var1].validate(var0.forChild(".term[" + var1 + "]"));
            }
        }

        @Override
        public LootItemConditionType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((LootTableInfo)object);
        }
    }
}

