/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.slf4j.Logger;

public class WorldPersistentData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Map<String, PersistentBase> cache = Maps.newHashMap();
    private final DataFixer fixerUpper;
    private final File dataFolder;

    public WorldPersistentData(File var0, DataFixer var1) {
        this.fixerUpper = var1;
        this.dataFolder = var0;
    }

    private File getDataFile(String var0) {
        return new File(this.dataFolder, var0 + ".dat");
    }

    public <T extends PersistentBase> T computeIfAbsent(Function<NBTTagCompound, T> var0, Supplier<T> var1, String var2) {
        T var3 = this.get(var0, var2);
        if (var3 != null) {
            return var3;
        }
        PersistentBase var4 = (PersistentBase)var1.get();
        this.set(var2, var4);
        return (T)var4;
    }

    @Nullable
    public <T extends PersistentBase> T get(Function<NBTTagCompound, T> var0, String var1) {
        PersistentBase var2 = this.cache.get(var1);
        if (var2 == null && !this.cache.containsKey(var1)) {
            var2 = this.readSavedData(var0, var1);
            this.cache.put(var1, var2);
        }
        return (T)var2;
    }

    @Nullable
    private <T extends PersistentBase> T readSavedData(Function<NBTTagCompound, T> var0, String var1) {
        try {
            File var2 = this.getDataFile(var1);
            if (var2.exists()) {
                NBTTagCompound var3 = this.readTagFromDisk(var1, SharedConstants.getCurrentVersion().getWorldVersion());
                return (T)((PersistentBase)var0.apply(var3.getCompound("data")));
            }
        }
        catch (Exception var2) {
            LOGGER.error("Error loading saved data: {}", (Object)var1, (Object)var2);
        }
        return null;
    }

    public void set(String var0, PersistentBase var1) {
        this.cache.put(var0, var1);
    }

    public NBTTagCompound readTagFromDisk(String var0, int var1) throws IOException {
        File var2 = this.getDataFile(var0);
        try (FileInputStream var3 = new FileInputStream(var2);){
            NBTTagCompound nBTTagCompound;
            try (PushbackInputStream var4 = new PushbackInputStream(var3, 2);){
                NBTTagCompound var5;
                if (this.isGzip(var4)) {
                    var5 = NBTCompressedStreamTools.readCompressed(var4);
                } else {
                    try (DataInputStream var6 = new DataInputStream(var4);){
                        var5 = NBTCompressedStreamTools.read(var6);
                    }
                }
                int var6 = var5.contains("DataVersion", 99) ? var5.getInt("DataVersion") : 1343;
                nBTTagCompound = GameProfileSerializer.update(this.fixerUpper, DataFixTypes.SAVED_DATA, var5, var6, var1);
            }
            return nBTTagCompound;
        }
    }

    private boolean isGzip(PushbackInputStream var0) throws IOException {
        int var4;
        byte[] var1 = new byte[2];
        boolean var2 = false;
        int var3 = var0.read(var1, 0, 2);
        if (var3 == 2 && (var4 = (var1[1] & 0xFF) << 8 | var1[0] & 0xFF) == 35615) {
            var2 = true;
        }
        if (var3 != 0) {
            var0.unread(var1, 0, var3);
        }
        return var2;
    }

    public void save() {
        this.cache.forEach((var0, var1) -> {
            if (var1 != null) {
                var1.save(this.getDataFile((String)var0));
            }
        });
    }
}

