/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;

public class MapIcon {
    private final Type type;
    private final byte x;
    private final byte y;
    private final byte rot;
    @Nullable
    private final IChatBaseComponent name;

    public MapIcon(Type var0, byte var1, byte var2, byte var3, @Nullable IChatBaseComponent var4) {
        this.type = var0;
        this.x = var1;
        this.y = var2;
        this.rot = var3;
        this.name = var4;
    }

    public byte getImage() {
        return this.type.getIcon();
    }

    public Type getType() {
        return this.type;
    }

    public byte getX() {
        return this.x;
    }

    public byte getY() {
        return this.y;
    }

    public byte getRot() {
        return this.rot;
    }

    public boolean renderOnFrame() {
        return this.type.isRenderedOnFrame();
    }

    @Nullable
    public IChatBaseComponent getName() {
        return this.name;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof MapIcon)) {
            return false;
        }
        MapIcon var1 = (MapIcon)var0;
        return this.type == var1.type && this.rot == var1.rot && this.x == var1.x && this.y == var1.y && Objects.equals(this.name, var1.name);
    }

    public int hashCode() {
        int var0 = this.type.getIcon();
        var0 = 31 * var0 + this.x;
        var0 = 31 * var0 + this.y;
        var0 = 31 * var0 + this.rot;
        var0 = 31 * var0 + Objects.hashCode(this.name);
        return var0;
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type PLAYER = new Type(false, true);
        public static final /* enum */ Type FRAME = new Type(true, true);
        public static final /* enum */ Type RED_MARKER = new Type(false, true);
        public static final /* enum */ Type BLUE_MARKER = new Type(false, true);
        public static final /* enum */ Type TARGET_X = new Type(true, false);
        public static final /* enum */ Type TARGET_POINT = new Type(true, false);
        public static final /* enum */ Type PLAYER_OFF_MAP = new Type(false, true);
        public static final /* enum */ Type PLAYER_OFF_LIMITS = new Type(false, true);
        public static final /* enum */ Type MANSION = new Type(true, 5393476, false);
        public static final /* enum */ Type MONUMENT = new Type(true, 3830373, false);
        public static final /* enum */ Type BANNER_WHITE = new Type(true, true);
        public static final /* enum */ Type BANNER_ORANGE = new Type(true, true);
        public static final /* enum */ Type BANNER_MAGENTA = new Type(true, true);
        public static final /* enum */ Type BANNER_LIGHT_BLUE = new Type(true, true);
        public static final /* enum */ Type BANNER_YELLOW = new Type(true, true);
        public static final /* enum */ Type BANNER_LIME = new Type(true, true);
        public static final /* enum */ Type BANNER_PINK = new Type(true, true);
        public static final /* enum */ Type BANNER_GRAY = new Type(true, true);
        public static final /* enum */ Type BANNER_LIGHT_GRAY = new Type(true, true);
        public static final /* enum */ Type BANNER_CYAN = new Type(true, true);
        public static final /* enum */ Type BANNER_PURPLE = new Type(true, true);
        public static final /* enum */ Type BANNER_BLUE = new Type(true, true);
        public static final /* enum */ Type BANNER_BROWN = new Type(true, true);
        public static final /* enum */ Type BANNER_GREEN = new Type(true, true);
        public static final /* enum */ Type BANNER_RED = new Type(true, true);
        public static final /* enum */ Type BANNER_BLACK = new Type(true, true);
        public static final /* enum */ Type RED_X = new Type(true, false);
        private final byte icon;
        private final boolean renderedOnFrame;
        private final int mapColor;
        private final boolean trackCount;
        private static final /* synthetic */ Type[] F;

        public static Type[] values() {
            return (Type[])F.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private Type(boolean var2, boolean var3) {
            this(var2, -1, var3);
        }

        private Type(boolean var2, int var3, boolean var4) {
            this.trackCount = var4;
            this.icon = (byte)this.ordinal();
            this.renderedOnFrame = var2;
            this.mapColor = var3;
        }

        public byte getIcon() {
            return this.icon;
        }

        public boolean isRenderedOnFrame() {
            return this.renderedOnFrame;
        }

        public boolean hasMapColor() {
            return this.mapColor >= 0;
        }

        public int getMapColor() {
            return this.mapColor;
        }

        public static Type byIcon(byte var0) {
            return Type.values()[MathHelper.clamp((int)var0, 0, Type.values().length - 1)];
        }

        public boolean shouldTrackCount() {
            return this.trackCount;
        }

        private static /* synthetic */ Type[] f() {
            return new Type[]{PLAYER, FRAME, RED_MARKER, BLUE_MARKER, TARGET_X, TARGET_POINT, PLAYER_OFF_MAP, PLAYER_OFF_LIMITS, MANSION, MONUMENT, BANNER_WHITE, BANNER_ORANGE, BANNER_MAGENTA, BANNER_LIGHT_BLUE, BANNER_YELLOW, BANNER_LIME, BANNER_PINK, BANNER_GRAY, BANNER_LIGHT_GRAY, BANNER_CYAN, BANNER_PURPLE, BANNER_BLUE, BANNER_BROWN, BANNER_GREEN, BANNER_RED, BANNER_BLACK, RED_X};
        }

        static {
            F = Type.f();
        }
    }
}

