/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.Vec3D;

public class BlockPortalShape {
    private static final int MIN_WIDTH = 2;
    public static final int MAX_WIDTH = 21;
    private static final int MIN_HEIGHT = 3;
    public static final int MAX_HEIGHT = 21;
    private static final BlockBase.e FRAME = (var0, var1, var2) -> var0.is(Blocks.OBSIDIAN);
    private final GeneratorAccess level;
    private final EnumDirection.EnumAxis axis;
    private final EnumDirection rightDir;
    private int numPortalBlocks;
    @Nullable
    private BlockPosition bottomLeft;
    private int height;
    private final int width;

    public static Optional<BlockPortalShape> findEmptyPortalShape(GeneratorAccess var02, BlockPosition var1, EnumDirection.EnumAxis var2) {
        return BlockPortalShape.findPortalShape(var02, var1, var0 -> var0.isValid() && var0.numPortalBlocks == 0, var2);
    }

    public static Optional<BlockPortalShape> findPortalShape(GeneratorAccess var0, BlockPosition var1, Predicate<BlockPortalShape> var2, EnumDirection.EnumAxis var3) {
        Optional<BlockPortalShape> var4 = Optional.of(new BlockPortalShape(var0, var1, var3)).filter(var2);
        if (var4.isPresent()) {
            return var4;
        }
        EnumDirection.EnumAxis var5 = var3 == EnumDirection.EnumAxis.X ? EnumDirection.EnumAxis.Z : EnumDirection.EnumAxis.X;
        return Optional.of(new BlockPortalShape(var0, var1, var5)).filter(var2);
    }

    public BlockPortalShape(GeneratorAccess var0, BlockPosition var1, EnumDirection.EnumAxis var2) {
        this.level = var0;
        this.axis = var2;
        this.rightDir = var2 == EnumDirection.EnumAxis.X ? EnumDirection.WEST : EnumDirection.SOUTH;
        this.bottomLeft = this.calculateBottomLeft(var1);
        if (this.bottomLeft == null) {
            this.bottomLeft = var1;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.calculateWidth();
            if (this.width > 0) {
                this.height = this.calculateHeight();
            }
        }
    }

    @Nullable
    private BlockPosition calculateBottomLeft(BlockPosition var0) {
        int var1 = Math.max(this.level.getMinBuildHeight(), var0.getY() - 21);
        while (var0.getY() > var1 && BlockPortalShape.isEmpty(this.level.getBlockState(var0.below()))) {
            var0 = var0.below();
        }
        EnumDirection var2 = this.rightDir.getOpposite();
        int var3 = this.getDistanceUntilEdgeAboveFrame(var0, var2) - 1;
        if (var3 < 0) {
            return null;
        }
        return var0.relative(var2, var3);
    }

    private int calculateWidth() {
        int var0 = this.getDistanceUntilEdgeAboveFrame(this.bottomLeft, this.rightDir);
        if (var0 < 2 || var0 > 21) {
            return 0;
        }
        return var0;
    }

    private int getDistanceUntilEdgeAboveFrame(BlockPosition var0, EnumDirection var1) {
        BlockPosition.MutableBlockPosition var2 = new BlockPosition.MutableBlockPosition();
        for (int var3 = 0; var3 <= 21; ++var3) {
            var2.set(var0).move(var1, var3);
            IBlockData var4 = this.level.getBlockState(var2);
            if (!BlockPortalShape.isEmpty(var4)) {
                if (!FRAME.test(var4, this.level, var2)) break;
                return var3;
            }
            IBlockData var5 = this.level.getBlockState(var2.move(EnumDirection.DOWN));
            if (!FRAME.test(var5, this.level, var2)) break;
        }
        return 0;
    }

    private int calculateHeight() {
        BlockPosition.MutableBlockPosition var0 = new BlockPosition.MutableBlockPosition();
        int var1 = this.getDistanceUntilTop(var0);
        if (var1 < 3 || var1 > 21 || !this.hasTopFrame(var0, var1)) {
            return 0;
        }
        return var1;
    }

    private boolean hasTopFrame(BlockPosition.MutableBlockPosition var0, int var1) {
        for (int var2 = 0; var2 < this.width; ++var2) {
            BlockPosition.MutableBlockPosition var3 = var0.set(this.bottomLeft).move(EnumDirection.UP, var1).move(this.rightDir, var2);
            if (FRAME.test(this.level.getBlockState(var3), this.level, var3)) continue;
            return false;
        }
        return true;
    }

    private int getDistanceUntilTop(BlockPosition.MutableBlockPosition var0) {
        for (int var1 = 0; var1 < 21; ++var1) {
            var0.set(this.bottomLeft).move(EnumDirection.UP, var1).move(this.rightDir, -1);
            if (!FRAME.test(this.level.getBlockState(var0), this.level, var0)) {
                return var1;
            }
            var0.set(this.bottomLeft).move(EnumDirection.UP, var1).move(this.rightDir, this.width);
            if (!FRAME.test(this.level.getBlockState(var0), this.level, var0)) {
                return var1;
            }
            for (int var2 = 0; var2 < this.width; ++var2) {
                var0.set(this.bottomLeft).move(EnumDirection.UP, var1).move(this.rightDir, var2);
                IBlockData var3 = this.level.getBlockState(var0);
                if (!BlockPortalShape.isEmpty(var3)) {
                    return var1;
                }
                if (!var3.is(Blocks.NETHER_PORTAL)) continue;
                ++this.numPortalBlocks;
            }
        }
        return 21;
    }

    private static boolean isEmpty(IBlockData var0) {
        return var0.isAir() || var0.is(TagsBlock.FIRE) || var0.is(Blocks.NETHER_PORTAL);
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortalBlocks() {
        IBlockData var0 = (IBlockData)Blocks.NETHER_PORTAL.defaultBlockState().setValue(BlockPortal.AXIS, this.axis);
        BlockPosition.betweenClosed(this.bottomLeft, this.bottomLeft.relative(EnumDirection.UP, this.height - 1).relative(this.rightDir, this.width - 1)).forEach(var1 -> this.level.setBlock((BlockPosition)var1, var0, 18));
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }

    public static Vec3D getRelativePosition(BlockUtil.Rectangle var0, EnumDirection.EnumAxis var1, Vec3D var2, EntitySize var3) {
        double var11;
        EnumDirection.EnumAxis var13;
        double var9;
        double var4 = (double)var0.axis1Size - (double)var3.width;
        double var6 = (double)var0.axis2Size - (double)var3.height;
        BlockPosition var8 = var0.minCorner;
        if (var4 > 0.0) {
            float var112 = (float)var8.get(var1) + var3.width / 2.0f;
            var9 = MathHelper.clamp(MathHelper.inverseLerp(var2.get(var1) - (double)var112, 0.0, var4), 0.0, 1.0);
        } else {
            var9 = 0.5;
        }
        if (var6 > 0.0) {
            var13 = EnumDirection.EnumAxis.Y;
            var11 = MathHelper.clamp(MathHelper.inverseLerp(var2.get(var13) - (double)var8.get(var13), 0.0, var6), 0.0, 1.0);
        } else {
            var11 = 0.0;
        }
        var13 = var1 == EnumDirection.EnumAxis.X ? EnumDirection.EnumAxis.Z : EnumDirection.EnumAxis.X;
        double var14 = var2.get(var13) - ((double)var8.get(var13) + 0.5);
        return new Vec3D(var9, var11, var14);
    }

    public static ShapeDetectorShape createPortalInfo(WorldServer var0, BlockUtil.Rectangle var1, EnumDirection.EnumAxis var2, Vec3D var3, EntitySize var4, Vec3D var5, float var6, float var7) {
        BlockPosition var8 = var1.minCorner;
        IBlockData var9 = var0.getBlockState(var8);
        EnumDirection.EnumAxis var10 = var9.getOptionalValue(BlockProperties.HORIZONTAL_AXIS).orElse(EnumDirection.EnumAxis.X);
        double var11 = var1.axis1Size;
        double var13 = var1.axis2Size;
        int var15 = var2 == var10 ? 0 : 90;
        Vec3D var16 = var2 == var10 ? var5 : new Vec3D(var5.z, var5.y, -var5.x);
        double var17 = (double)var4.width / 2.0 + (var11 - (double)var4.width) * var3.x();
        double var19 = (var13 - (double)var4.height) * var3.y();
        double var21 = 0.5 + var3.z();
        boolean var23 = var10 == EnumDirection.EnumAxis.X;
        Vec3D var24 = new Vec3D((double)var8.getX() + (var23 ? var17 : var21), (double)var8.getY() + var19, (double)var8.getZ() + (var23 ? var21 : var17));
        return new ShapeDetectorShape(var24, var16, var6 + (float)var15, var7);
    }
}

