/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class FluidType {
    public static final RegistryBlockID<Fluid> FLUID_STATE_REGISTRY = new RegistryBlockID();
    protected final BlockStateList<FluidType, Fluid> stateDefinition;
    private Fluid defaultFluidState;
    private final Holder.c<FluidType> builtInRegistryHolder = IRegistry.FLUID.createIntrusiveHolder(this);

    protected FluidType() {
        BlockStateList.a<FluidType, Fluid> var0 = new BlockStateList.a<FluidType, Fluid>(this);
        this.createFluidStateDefinition(var0);
        this.stateDefinition = var0.create(FluidType::defaultFluidState, Fluid::new);
        this.registerDefaultState(this.stateDefinition.any());
    }

    protected void createFluidStateDefinition(BlockStateList.a<FluidType, Fluid> var0) {
    }

    public BlockStateList<FluidType, Fluid> getStateDefinition() {
        return this.stateDefinition;
    }

    protected final void registerDefaultState(Fluid var0) {
        this.defaultFluidState = var0;
    }

    public final Fluid defaultFluidState() {
        return this.defaultFluidState;
    }

    public abstract Item getBucket();

    protected void animateTick(World var0, BlockPosition var1, Fluid var2, RandomSource var3) {
    }

    protected void tick(World var0, BlockPosition var1, Fluid var2) {
    }

    protected void randomTick(World var0, BlockPosition var1, Fluid var2, RandomSource var3) {
    }

    @Nullable
    protected ParticleParam getDripParticle() {
        return null;
    }

    protected abstract boolean canBeReplacedWith(Fluid var1, IBlockAccess var2, BlockPosition var3, FluidType var4, EnumDirection var5);

    protected abstract Vec3D getFlow(IBlockAccess var1, BlockPosition var2, Fluid var3);

    public abstract int getTickDelay(IWorldReader var1);

    protected boolean isRandomlyTicking() {
        return false;
    }

    protected boolean isEmpty() {
        return false;
    }

    protected abstract float getExplosionResistance();

    public abstract float getHeight(Fluid var1, IBlockAccess var2, BlockPosition var3);

    public abstract float getOwnHeight(Fluid var1);

    protected abstract IBlockData createLegacyBlock(Fluid var1);

    public abstract boolean isSource(Fluid var1);

    public abstract int getAmount(Fluid var1);

    public boolean isSame(FluidType var0) {
        return var0 == this;
    }

    @Deprecated
    public boolean is(TagKey<FluidType> var0) {
        return this.builtInRegistryHolder.is(var0);
    }

    public abstract VoxelShape getShape(Fluid var1, IBlockAccess var2, BlockPosition var3);

    public Optional<SoundEffect> getPickupSound() {
        return Optional.empty();
    }

    @Deprecated
    public Holder.c<FluidType> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }
}

