/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdPieces;

public class StrongholdStructure
extends Structure {
    public static final Codec<StrongholdStructure> CODEC = StrongholdStructure.simpleCodec(StrongholdStructure::new);

    public StrongholdStructure(Structure.c var0) {
        super(var0);
    }

    @Override
    public Optional<Structure.b> findGenerationPoint(Structure.a var0) {
        return Optional.of(new Structure.b(var0.chunkPos().getWorldPosition(), var1 -> StrongholdStructure.generatePieces(var1, var0)));
    }

    private static void generatePieces(StructurePiecesBuilder var0, Structure.a var1) {
        StrongholdPieces.m var3;
        int var2 = 0;
        do {
            var0.clear();
            var1.random().setLargeFeatureSeed(var1.seed() + (long)var2++, var1.chunkPos().x, var1.chunkPos().z);
            StrongholdPieces.resetPieces();
            var3 = new StrongholdPieces.m(var1.random(), var1.chunkPos().getBlockX(2), var1.chunkPos().getBlockZ(2));
            var0.addPiece(var3);
            var3.addChildren(var3, var0, var1.random());
            List<StructurePiece> var4 = var3.pendingChildren;
            while (!var4.isEmpty()) {
                int var5 = var1.random().nextInt(var4.size());
                StructurePiece var6 = var4.remove(var5);
                var6.addChildren(var3, var0, var1.random());
            }
            var0.moveBelowSeaLevel(var1.chunkGenerator().getSeaLevel(), var1.chunkGenerator().getMinY(), var1.random(), 10);
        } while (var0.isEmpty() || var3.portalRoomPiece == null);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.STRONGHOLD;
    }
}

