/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockVine;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlackstoneReplace;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockAge;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorLavaSubmergedBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorPredicates;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestRandomBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public class RuinedPortalPiece
extends DefinedStructurePiece {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float PROBABILITY_OF_GOLD_GONE = 0.3f;
    private static final float PROBABILITY_OF_MAGMA_INSTEAD_OF_NETHERRACK = 0.07f;
    private static final float PROBABILITY_OF_MAGMA_INSTEAD_OF_LAVA = 0.2f;
    private final b verticalPlacement;
    private final a properties;

    public RuinedPortalPiece(StructureTemplateManager var0, BlockPosition var1, b var2, a var3, MinecraftKey var4, DefinedStructure var5, EnumBlockRotation var6, EnumBlockMirror var7, BlockPosition var8) {
        super(WorldGenFeatureStructurePieceType.RUINED_PORTAL, 0, var0, var4, var4.toString(), RuinedPortalPiece.makeSettings(var7, var6, var2, var8, var3), var1);
        this.verticalPlacement = var2;
        this.properties = var3;
    }

    public RuinedPortalPiece(StructureTemplateManager var0, NBTTagCompound var1) {
        super(WorldGenFeatureStructurePieceType.RUINED_PORTAL, var1, var0, var2 -> RuinedPortalPiece.makeSettings(var0, var1, var2));
        this.verticalPlacement = b.byName(var1.getString("VerticalPlacement"));
        this.properties = (a)a.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var1.get("Properties"))).getOrThrow(true, arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var12) {
        super.addAdditionalSaveData(var0, var12);
        var12.putString("Rotation", this.placeSettings.getRotation().name());
        var12.putString("Mirror", this.placeSettings.getMirror().name());
        var12.putString("VerticalPlacement", this.verticalPlacement.getName());
        a.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.properties).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var12.put("Properties", (NBTBase)var1));
    }

    private static DefinedStructureInfo makeSettings(StructureTemplateManager var0, NBTTagCompound var1, MinecraftKey var2) {
        DefinedStructure var3 = var0.getOrCreate(var2);
        BlockPosition var4 = new BlockPosition(var3.getSize().getX() / 2, 0, var3.getSize().getZ() / 2);
        return RuinedPortalPiece.makeSettings(EnumBlockMirror.valueOf(var1.getString("Mirror")), EnumBlockRotation.valueOf(var1.getString("Rotation")), b.byName(var1.getString("VerticalPlacement")), var4, (a)a.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var1.get("Properties"))).getOrThrow(true, arg_0 -> ((Logger)LOGGER).error(arg_0)));
    }

    private static DefinedStructureInfo makeSettings(EnumBlockMirror var0, EnumBlockRotation var1, b var2, BlockPosition var3, a var4) {
        DefinedStructureProcessorBlockIgnore var5 = var4.airPocket ? DefinedStructureProcessorBlockIgnore.STRUCTURE_BLOCK : DefinedStructureProcessorBlockIgnore.STRUCTURE_AND_AIR;
        ArrayList var6 = Lists.newArrayList();
        var6.add(RuinedPortalPiece.getBlockReplaceRule(Blocks.GOLD_BLOCK, 0.3f, Blocks.AIR));
        var6.add(RuinedPortalPiece.getLavaProcessorRule(var2, var4));
        if (!var4.cold) {
            var6.add(RuinedPortalPiece.getBlockReplaceRule(Blocks.NETHERRACK, 0.07f, Blocks.MAGMA_BLOCK));
        }
        DefinedStructureInfo var7 = new DefinedStructureInfo().setRotation(var1).setMirror(var0).setRotationPivot(var3).addProcessor(var5).addProcessor(new DefinedStructureProcessorRule(var6)).addProcessor(new DefinedStructureProcessorBlockAge(var4.mossiness)).addProcessor(new ProtectedBlockProcessor(TagsBlock.FEATURES_CANNOT_REPLACE)).addProcessor(new DefinedStructureProcessorLavaSubmergedBlock());
        if (var4.replaceWithBlackstone) {
            var7.addProcessor(DefinedStructureProcessorBlackstoneReplace.INSTANCE);
        }
        return var7;
    }

    private static DefinedStructureProcessorPredicates getLavaProcessorRule(b var0, a var1) {
        if (var0 == b.ON_OCEAN_FLOOR) {
            return RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, Blocks.MAGMA_BLOCK);
        }
        if (var1.cold) {
            return RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, Blocks.NETHERRACK);
        }
        return RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, 0.2f, Blocks.MAGMA_BLOCK);
    }

    @Override
    public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var22, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
        StructureBoundingBox var7 = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
        if (!var4.isInside(var7.getCenter())) {
            return;
        }
        var4.encapsulate(var7);
        super.postProcess(var0, var1, var22, var3, var4, var5, var6);
        this.spreadNetherrack(var3, var0);
        this.addNetherrackDripColumnsBelowPortal(var3, var0);
        if (this.properties.vines || this.properties.overgrown) {
            BlockPosition.betweenClosedStream(this.getBoundingBox()).forEach(var2 -> {
                if (this.properties.vines) {
                    this.maybeAddVines(var3, var0, (BlockPosition)var2);
                }
                if (this.properties.overgrown) {
                    this.maybeAddLeavesAbove(var3, var0, (BlockPosition)var2);
                }
            });
        }
    }

    @Override
    protected void handleDataMarker(String var0, BlockPosition var1, WorldAccess var2, RandomSource var3, StructureBoundingBox var4) {
    }

    private void maybeAddVines(RandomSource var0, GeneratorAccess var1, BlockPosition var2) {
        IBlockData var3 = var1.getBlockState(var2);
        if (var3.isAir() || var3.is(Blocks.VINE)) {
            return;
        }
        EnumDirection var4 = RuinedPortalPiece.getRandomHorizontalDirection(var0);
        BlockPosition var5 = var2.relative(var4);
        IBlockData var6 = var1.getBlockState(var5);
        if (!var6.isAir()) {
            return;
        }
        if (!Block.isFaceFull(var3.getCollisionShape(var1, var2), var4)) {
            return;
        }
        BlockStateBoolean var7 = BlockVine.getPropertyForFace(var4.getOpposite());
        var1.setBlock(var5, (IBlockData)Blocks.VINE.defaultBlockState().setValue(var7, true), 3);
    }

    private void maybeAddLeavesAbove(RandomSource var0, GeneratorAccess var1, BlockPosition var2) {
        if (var0.nextFloat() < 0.5f && var1.getBlockState(var2).is(Blocks.NETHERRACK) && var1.getBlockState(var2.above()).isAir()) {
            var1.setBlock(var2.above(), (IBlockData)Blocks.JUNGLE_LEAVES.defaultBlockState().setValue(BlockLeaves.PERSISTENT, true), 3);
        }
    }

    private void addNetherrackDripColumnsBelowPortal(RandomSource var0, GeneratorAccess var1) {
        for (int var2 = this.boundingBox.minX() + 1; var2 < this.boundingBox.maxX(); ++var2) {
            for (int var3 = this.boundingBox.minZ() + 1; var3 < this.boundingBox.maxZ(); ++var3) {
                BlockPosition var4 = new BlockPosition(var2, this.boundingBox.minY(), var3);
                if (!var1.getBlockState(var4).is(Blocks.NETHERRACK)) continue;
                this.addNetherrackDripColumn(var0, var1, var4.below());
            }
        }
    }

    private void addNetherrackDripColumn(RandomSource var0, GeneratorAccess var1, BlockPosition var2) {
        BlockPosition.MutableBlockPosition var3 = var2.mutable();
        this.placeNetherrackOrMagma(var0, var1, var3);
        for (int var4 = 8; var4 > 0 && var0.nextFloat() < 0.5f; --var4) {
            var3.move(EnumDirection.DOWN);
            this.placeNetherrackOrMagma(var0, var1, var3);
        }
    }

    private void spreadNetherrack(RandomSource var0, GeneratorAccess var1) {
        boolean var2 = this.verticalPlacement == b.ON_LAND_SURFACE || this.verticalPlacement == b.ON_OCEAN_FLOOR;
        BlockPosition var3 = this.boundingBox.getCenter();
        int var4 = var3.getX();
        int var5 = var3.getZ();
        float[] var6 = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int var7 = var6.length;
        int var8 = (this.boundingBox.getXSpan() + this.boundingBox.getZSpan()) / 2;
        int var9 = var0.nextInt(Math.max(1, 8 - var8 / 2));
        int var10 = 3;
        BlockPosition.MutableBlockPosition var11 = BlockPosition.ZERO.mutable();
        for (int var12 = var4 - var7; var12 <= var4 + var7; ++var12) {
            for (int var13 = var5 - var7; var13 <= var5 + var7; ++var13) {
                int var14 = Math.abs(var12 - var4) + Math.abs(var13 - var5);
                int var15 = Math.max(0, var14 + var9);
                if (var15 >= var7) continue;
                float var16 = var6[var15];
                if (!(var0.nextDouble() < (double)var16)) continue;
                int var17 = RuinedPortalPiece.getSurfaceY(var1, var12, var13, this.verticalPlacement);
                int var18 = var2 ? var17 : Math.min(this.boundingBox.minY(), var17);
                var11.set(var12, var18, var13);
                if (Math.abs(var18 - this.boundingBox.minY()) > 3 || !this.canBlockBeReplacedByNetherrackOrMagma(var1, var11)) continue;
                this.placeNetherrackOrMagma(var0, var1, var11);
                if (this.properties.overgrown) {
                    this.maybeAddLeavesAbove(var0, var1, var11);
                }
                this.addNetherrackDripColumn(var0, var1, (BlockPosition)var11.below());
            }
        }
    }

    private boolean canBlockBeReplacedByNetherrackOrMagma(GeneratorAccess var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        return !var2.is(Blocks.AIR) && !var2.is(Blocks.OBSIDIAN) && !var2.is(TagsBlock.FEATURES_CANNOT_REPLACE) && (this.verticalPlacement == b.IN_NETHER || !var2.is(Blocks.LAVA));
    }

    private void placeNetherrackOrMagma(RandomSource var0, GeneratorAccess var1, BlockPosition var2) {
        if (!this.properties.cold && var0.nextFloat() < 0.07f) {
            var1.setBlock(var2, Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
        } else {
            var1.setBlock(var2, Blocks.NETHERRACK.defaultBlockState(), 3);
        }
    }

    private static int getSurfaceY(GeneratorAccess var0, int var1, int var2, b var3) {
        return var0.getHeight(RuinedPortalPiece.getHeightMapType(var3), var1, var2) - 1;
    }

    public static HeightMap.Type getHeightMapType(b var0) {
        return var0 == b.ON_OCEAN_FLOOR ? HeightMap.Type.OCEAN_FLOOR_WG : HeightMap.Type.WORLD_SURFACE_WG;
    }

    private static DefinedStructureProcessorPredicates getBlockReplaceRule(Block var0, float var1, Block var2) {
        return new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(var0, var1), DefinedStructureTestTrue.INSTANCE, var2.defaultBlockState());
    }

    private static DefinedStructureProcessorPredicates getBlockReplaceRule(Block var0, Block var1) {
        return new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(var0), DefinedStructureTestTrue.INSTANCE, var1.defaultBlockState());
    }

    public static final class b
    extends Enum<b>
    implements INamable {
        public static final /* enum */ b ON_LAND_SURFACE = new b("on_land_surface");
        public static final /* enum */ b PARTLY_BURIED = new b("partly_buried");
        public static final /* enum */ b ON_OCEAN_FLOOR = new b("on_ocean_floor");
        public static final /* enum */ b IN_MOUNTAIN = new b("in_mountain");
        public static final /* enum */ b UNDERGROUND = new b("underground");
        public static final /* enum */ b IN_NETHER = new b("in_nether");
        public static final INamable.a<b> CODEC;
        private final String name;
        private static final /* synthetic */ b[] i;

        public static b[] values() {
            return (b[])i.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private b(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        public static b byName(String var0) {
            return CODEC.byName(var0);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ b[] b() {
            return new b[]{ON_LAND_SURFACE, PARTLY_BURIED, ON_OCEAN_FLOOR, IN_MOUNTAIN, UNDERGROUND, IN_NETHER};
        }

        static {
            i = b.b();
            CODEC = INamable.fromEnum(b::values);
        }
    }

    public static class a {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.BOOL.fieldOf("cold").forGetter(var0 -> var0.cold), (App)Codec.FLOAT.fieldOf("mossiness").forGetter(var0 -> Float.valueOf(var0.mossiness)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(var0 -> var0.airPocket), (App)Codec.BOOL.fieldOf("overgrown").forGetter(var0 -> var0.overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(var0 -> var0.vines), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(var0 -> var0.replaceWithBlackstone)).apply((Applicative)var02, a::new));
        public boolean cold;
        public float mossiness;
        public boolean airPocket;
        public boolean overgrown;
        public boolean vines;
        public boolean replaceWithBlackstone;

        public a() {
        }

        public a(boolean var0, float var1, boolean var2, boolean var3, boolean var4, boolean var5) {
            this.cold = var0;
            this.mossiness = var1;
            this.airPocket = var2;
            this.overgrown = var3;
            this.vines = var4;
            this.replaceWithBlackstone = var5;
        }
    }
}

