/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces;

public class MineshaftStructure
extends Structure {
    public static final Codec<MineshaftStructure> CODEC = RecordCodecBuilder.create(var02 -> var02.group(MineshaftStructure.settingsCodec(var02), (App)a.CODEC.fieldOf("mineshaft_type").forGetter(var0 -> var0.type)).apply((Applicative)var02, MineshaftStructure::new));
    private final a type;

    public MineshaftStructure(Structure.c var0, a var1) {
        super(var0);
        this.type = var1;
    }

    @Override
    public Optional<Structure.b> findGenerationPoint(Structure.a var0) {
        var0.random().nextDouble();
        ChunkCoordIntPair var1 = var0.chunkPos();
        BlockPosition var2 = new BlockPosition(var1.getMiddleBlockX(), 50, var1.getMinBlockZ());
        StructurePiecesBuilder var3 = new StructurePiecesBuilder();
        int var4 = this.generatePiecesAndAdjust(var3, var0);
        return Optional.of(new Structure.b(var2.offset(0, var4, 0), (Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder>)Either.right((Object)var3)));
    }

    private int generatePiecesAndAdjust(StructurePiecesBuilder var0, Structure.a var1) {
        ChunkCoordIntPair var2 = var1.chunkPos();
        SeededRandom var3 = var1.random();
        ChunkGenerator var4 = var1.chunkGenerator();
        MineshaftPieces.d var5 = new MineshaftPieces.d(0, var3, var2.getBlockX(2), var2.getBlockZ(2), this.type);
        var0.addPiece(var5);
        var5.addChildren(var5, var0, var3);
        int var6 = var4.getSeaLevel();
        if (this.type == a.MESA) {
            BlockPosition var7 = var0.getBoundingBox().getCenter();
            int var8 = var4.getBaseHeight(var7.getX(), var7.getZ(), HeightMap.Type.WORLD_SURFACE_WG, var1.heightAccessor(), var1.randomState());
            int var9 = var8 <= var6 ? var6 : MathHelper.randomBetweenInclusive(var3, var6, var8);
            int var10 = var9 - var7.getY();
            var0.offsetPiecesVertically(var10);
            return var10;
        }
        return var0.moveBelowSeaLevel(var6, var4.getMinY(), var3, 10);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.MINESHAFT;
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a NORMAL = new a("normal", Blocks.OAK_LOG, Blocks.OAK_PLANKS, Blocks.OAK_FENCE);
        public static final /* enum */ a MESA = new a("mesa", Blocks.DARK_OAK_LOG, Blocks.DARK_OAK_PLANKS, Blocks.DARK_OAK_FENCE);
        public static final Codec<a> CODEC;
        private final String name;
        private final IBlockData woodState;
        private final IBlockData planksState;
        private final IBlockData fenceState;
        private static final /* synthetic */ a[] h;

        public static a[] values() {
            return (a[])h.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2, Block var3, Block var4, Block var5) {
            this.name = var2;
            this.woodState = var3.defaultBlockState();
            this.planksState = var4.defaultBlockState();
            this.fenceState = var5.defaultBlockState();
        }

        public String getName() {
            return this.name;
        }

        public static a byId(int var0) {
            if (var0 < 0 || var0 >= a.values().length) {
                return NORMAL;
            }
            return a.values()[var0];
        }

        public IBlockData getWoodState() {
            return this.woodState;
        }

        public IBlockData getPlanksState() {
            return this.planksState;
        }

        public IBlockData getFenceState() {
            return this.fenceState;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ a[] f() {
            return new a[]{NORMAL, MESA};
        }

        static {
            h = a.f();
            CODEC = INamable.fromEnum(a::values);
        }
    }
}

