/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.WorldGenFeaturePillagerOutpostPoolPiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class WorldGenFeatureDefinedStructureJigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<Structure.b> addPieces(Structure.a var0, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, Optional<MinecraftKey> var2, int var3, BlockPosition var4, boolean var5, Optional<HeightMap.Type> var6, int var7) {
        BlockPosition var17;
        Optional<BlockPosition> var19;
        Comparable<MinecraftKey> var18;
        IRegistryCustom var8 = var0.registryAccess();
        ChunkGenerator var9 = var0.chunkGenerator();
        StructureTemplateManager var10 = var0.structureTemplateManager();
        LevelHeightAccessor var11 = var0.heightAccessor();
        SeededRandom var12 = var0.random();
        IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> var13 = var8.registryOrThrow(IRegistry.TEMPLATE_POOL_REGISTRY);
        EnumBlockRotation var142 = EnumBlockRotation.getRandom(var12);
        WorldGenFeatureDefinedStructurePoolTemplate var15 = var1.value();
        WorldGenFeatureDefinedStructurePoolStructure var16 = var15.getRandomTemplate(var12);
        if (var16 == WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE) {
            return Optional.empty();
        }
        if (var2.isPresent()) {
            var18 = var2.get();
            var19 = WorldGenFeatureDefinedStructureJigsawPlacement.getRandomNamedJigsaw(var16, (MinecraftKey)var18, var4, var142, var10, var12);
            if (var19.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)var18, (Object)var1.unwrapKey().get().location());
                return Optional.empty();
            }
            var17 = (BlockPosition)var19.get();
        } else {
            var17 = var4;
        }
        var18 = var17.subtract(var4);
        var19 = var4.subtract((BaseBlockPosition)var18);
        WorldGenFeaturePillagerOutpostPoolPiece var20 = new WorldGenFeaturePillagerOutpostPoolPiece(var10, var16, (BlockPosition)((Object)var19), var16.getGroundLevelDelta(), var142, var16.getBoundingBox(var10, (BlockPosition)((Object)var19), var142));
        StructureBoundingBox var21 = var20.getBoundingBox();
        int var22 = (var21.maxX() + var21.minX()) / 2;
        int var23 = (var21.maxZ() + var21.minZ()) / 2;
        int var24 = var6.isPresent() ? var4.getY() + var9.getFirstFreeHeight(var22, var23, var6.get(), var11, var0.randomState()) : ((BaseBlockPosition)((Object)var19)).getY();
        int var25 = var21.minY() + var20.getGroundLevelDelta();
        var20.move(0, var24 - var25, 0);
        int var26 = var24 + ((BaseBlockPosition)var18).getY();
        return Optional.of(new Structure.b(new BlockPosition(var22, var26, var23), var14 -> {
            ArrayList var15 = Lists.newArrayList();
            var15.add(var20);
            if (var3 <= 0) {
                return;
            }
            AxisAlignedBB var16 = new AxisAlignedBB(var22 - var7, var26 - var7, var23 - var7, var22 + var7 + 1, var26 + var7 + 1, var23 + var7 + 1);
            VoxelShape var17 = VoxelShapes.join(VoxelShapes.create(var16), VoxelShapes.create(AxisAlignedBB.of(var21)), OperatorBoolean.ONLY_FIRST);
            WorldGenFeatureDefinedStructureJigsawPlacement.addPieces(var0.randomState(), var3, var5, var9, var10, var11, var12, var13, var20, var15, var17);
            var15.forEach(var14::addPiece);
        }));
    }

    private static Optional<BlockPosition> getRandomNamedJigsaw(WorldGenFeatureDefinedStructurePoolStructure var0, MinecraftKey var1, BlockPosition var2, EnumBlockRotation var3, StructureTemplateManager var4, SeededRandom var5) {
        List<DefinedStructure.BlockInfo> var6 = var0.getShuffledJigsawBlocks(var4, var2, var3, var5);
        Optional<BlockPosition> var7 = Optional.empty();
        for (DefinedStructure.BlockInfo var9 : var6) {
            MinecraftKey var10 = MinecraftKey.tryParse(var9.nbt.getString("name"));
            if (!var1.equals(var10)) continue;
            var7 = Optional.of(var9.pos);
            break;
        }
        return var7;
    }

    private static void addPieces(RandomState var0, int var1, boolean var2, ChunkGenerator var3, StructureTemplateManager var4, LevelHeightAccessor var5, RandomSource var6, IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> var7, WorldGenFeaturePillagerOutpostPoolPiece var8, List<WorldGenFeaturePillagerOutpostPoolPiece> var9, VoxelShape var10) {
        b var11 = new b(var7, var1, var3, var4, var9, var6);
        var11.placing.addLast(new a(var8, (MutableObject<VoxelShape>)new MutableObject((Object)var10), 0));
        while (!var11.placing.isEmpty()) {
            a var12 = var11.placing.removeFirst();
            var11.tryPlacingChildren(var12.piece, var12.free, var12.depth, var2, var5, var0);
        }
    }

    public static boolean generateJigsaw(WorldServer var02, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, MinecraftKey var2, int var3, BlockPosition var4, boolean var5) {
        ChunkGenerator var6 = var02.getChunkSource().getGenerator();
        StructureTemplateManager var7 = var02.getStructureManager();
        StructureManager var8 = var02.structureManager();
        RandomSource var9 = var02.getRandom();
        Structure.a var10 = new Structure.a(var02.registryAccess(), var6, var6.getBiomeSource(), var02.getChunkSource().randomState(), var7, var02.getSeed(), new ChunkCoordIntPair(var4), var02, var0 -> true);
        Optional<Structure.b> var11 = WorldGenFeatureDefinedStructureJigsawPlacement.addPieces(var10, var1, Optional.of(var2), var3, var4, false, Optional.empty(), 128);
        if (var11.isPresent()) {
            StructurePiecesBuilder var12 = var11.get().getPiecesBuilder();
            for (StructurePiece var14 : var12.build().pieces()) {
                if (!(var14 instanceof WorldGenFeaturePillagerOutpostPoolPiece)) continue;
                WorldGenFeaturePillagerOutpostPoolPiece var15 = (WorldGenFeaturePillagerOutpostPoolPiece)var14;
                var15.place(var02, var8, var6, var9, StructureBoundingBox.infinite(), var4, var5);
            }
            return true;
        }
        return false;
    }

    static final class b {
        private final IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super WorldGenFeaturePillagerOutpostPoolPiece> pieces;
        private final RandomSource random;
        final Deque<a> placing = Queues.newArrayDeque();

        b(IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> var0, int var1, ChunkGenerator var2, StructureTemplateManager var3, List<? super WorldGenFeaturePillagerOutpostPoolPiece> var4, RandomSource var5) {
            this.pools = var0;
            this.maxDepth = var1;
            this.chunkGenerator = var2;
            this.structureTemplateManager = var3;
            this.pieces = var4;
            this.random = var5;
        }

        void tryPlacingChildren(WorldGenFeaturePillagerOutpostPoolPiece var0, MutableObject<VoxelShape> var12, int var2, boolean var3, LevelHeightAccessor var4, RandomState var5) {
            WorldGenFeatureDefinedStructurePoolStructure var6 = var0.getElement();
            BlockPosition var7 = var0.getPosition();
            EnumBlockRotation var8 = var0.getRotation();
            WorldGenFeatureDefinedStructurePoolTemplate.Matching var9 = var6.getProjection();
            boolean var10 = var9 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID;
            MutableObject<VoxelShape> var11 = new MutableObject<VoxelShape>();
            StructureBoundingBox var122 = var0.getBoundingBox();
            int var13 = var122.minY();
            block0: for (DefinedStructure.BlockInfo var15 : var6.getShuffledJigsawBlocks(this.structureTemplateManager, var7, var8, this.random)) {
                WorldGenFeatureDefinedStructurePoolStructure var29;
                MutableObject<VoxelShape> var25;
                EnumDirection var16 = BlockJigsaw.getFrontFacing(var15.state);
                BlockPosition var17 = var15.pos;
                BlockPosition var18 = var17.relative(var16);
                int var19 = var17.getY() - var13;
                int var20 = -1;
                MinecraftKey var21 = new MinecraftKey(var15.nbt.getString("pool"));
                Optional<WorldGenFeatureDefinedStructurePoolTemplate> var22 = this.pools.getOptional(var21);
                if (!var22.isPresent() || var22.get().size() == 0 && !Objects.equals(var21, WorldGenFeaturePieces.EMPTY.location())) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)var21);
                    continue;
                }
                MinecraftKey var23 = var22.get().getFallback();
                Optional<WorldGenFeatureDefinedStructurePoolTemplate> var24 = this.pools.getOptional(var23);
                if (!var24.isPresent() || var24.get().size() == 0 && !Objects.equals(var23, WorldGenFeaturePieces.EMPTY.location())) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)var23);
                    continue;
                }
                boolean var26 = var122.isInside(var18);
                if (var26) {
                    var25 = var11;
                    if (var11.getValue() == null) {
                        var11.setValue((Object)VoxelShapes.create(AxisAlignedBB.of(var122)));
                    }
                } else {
                    var25 = var12;
                }
                ArrayList var27 = Lists.newArrayList();
                if (var2 != this.maxDepth) {
                    var27.addAll(var22.get().getShuffledTemplates(this.random));
                }
                var27.addAll(var24.get().getShuffledTemplates(this.random));
                Iterator iterator = var27.iterator();
                while (iterator.hasNext() && (var29 = (WorldGenFeatureDefinedStructurePoolStructure)iterator.next()) != WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE) {
                    for (EnumBlockRotation var31 : EnumBlockRotation.getShuffled(this.random)) {
                        List<DefinedStructure.BlockInfo> var32 = var29.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPosition.ZERO, var31, this.random);
                        StructureBoundingBox var33 = var29.getBoundingBox(this.structureTemplateManager, BlockPosition.ZERO, var31);
                        int var34 = !var3 || var33.getYSpan() > 16 ? 0 : var32.stream().mapToInt(var1 -> {
                            if (!var33.isInside(var1.pos.relative(BlockJigsaw.getFrontFacing(var1.state)))) {
                                return 0;
                            }
                            MinecraftKey var2 = new MinecraftKey(var1.nbt.getString("pool"));
                            Optional<WorldGenFeatureDefinedStructurePoolTemplate> var3 = this.pools.getOptional(var2);
                            Optional<Integer> var4 = var3.flatMap(var0 -> this.pools.getOptional(var0.getFallback()));
                            int var5 = var3.map(var0 -> var0.getMaxSize(this.structureTemplateManager)).orElse(0);
                            int var6 = var4.map(var0 -> var0.getMaxSize(this.structureTemplateManager)).orElse(0);
                            return Math.max(var5, var6);
                        }).max().orElse(0);
                        for (DefinedStructure.BlockInfo var36 : var32) {
                            int var52;
                            int var49;
                            int var45;
                            if (!BlockJigsaw.canAttach(var15, var36)) continue;
                            BlockPosition var37 = var36.pos;
                            BlockPosition var38 = var18.subtract(var37);
                            StructureBoundingBox var39 = var29.getBoundingBox(this.structureTemplateManager, var38, var31);
                            int var40 = var39.minY();
                            WorldGenFeatureDefinedStructurePoolTemplate.Matching var41 = var29.getProjection();
                            boolean var42 = var41 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID;
                            int var43 = var37.getY();
                            int var44 = var19 - var43 + BlockJigsaw.getFrontFacing(var15.state).getStepY();
                            if (var10 && var42) {
                                var45 = var13 + var44;
                            } else {
                                if (var20 == -1) {
                                    var20 = this.chunkGenerator.getFirstFreeHeight(var17.getX(), var17.getZ(), HeightMap.Type.WORLD_SURFACE_WG, var4, var5);
                                }
                                var45 = var20 - var43;
                            }
                            int var46 = var45 - var40;
                            StructureBoundingBox var47 = var39.moved(0, var46, 0);
                            BlockPosition var48 = var38.offset(0, var46, 0);
                            if (var34 > 0) {
                                var49 = Math.max(var34 + 1, var47.maxY() - var47.minY());
                                var47.encapsulate(new BlockPosition(var47.minX(), var47.minY() + var49, var47.minZ()));
                            }
                            if (VoxelShapes.joinIsNotEmpty((VoxelShape)var25.getValue(), VoxelShapes.create(AxisAlignedBB.of(var47).deflate(0.25)), OperatorBoolean.ONLY_SECOND)) continue;
                            var25.setValue((Object)VoxelShapes.joinUnoptimized((VoxelShape)var25.getValue(), VoxelShapes.create(AxisAlignedBB.of(var47)), OperatorBoolean.ONLY_FIRST));
                            var49 = var0.getGroundLevelDelta();
                            int var50 = var42 ? var49 - var44 : var29.getGroundLevelDelta();
                            WorldGenFeaturePillagerOutpostPoolPiece var51 = new WorldGenFeaturePillagerOutpostPoolPiece(this.structureTemplateManager, var29, var48, var50, var31, var47);
                            if (var10) {
                                var52 = var13 + var19;
                            } else if (var42) {
                                var52 = var45 + var43;
                            } else {
                                if (var20 == -1) {
                                    var20 = this.chunkGenerator.getFirstFreeHeight(var17.getX(), var17.getZ(), HeightMap.Type.WORLD_SURFACE_WG, var4, var5);
                                }
                                var52 = var20 + var44 / 2;
                            }
                            var0.addJunction(new WorldGenFeatureDefinedStructureJigsawJunction(var18.getX(), var52 - var19 + var49, var18.getZ(), var44, var41));
                            var51.addJunction(new WorldGenFeatureDefinedStructureJigsawJunction(var17.getX(), var52 - var43 + var50, var17.getZ(), -var44, var9));
                            this.pieces.add(var51);
                            if (var2 + 1 > this.maxDepth) continue block0;
                            this.placing.addLast(new a(var51, var25, var2 + 1));
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    static final class a {
        final WorldGenFeaturePillagerOutpostPoolPiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        a(WorldGenFeaturePillagerOutpostPoolPiece var0, MutableObject<VoxelShape> var1, int var2) {
            this.piece = var0;
            this.free = var1;
            this.depth = var2;
        }
    }
}

