/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.QuartPos;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public abstract class Structure {
    public static final Codec<Structure> DIRECT_CODEC = IRegistry.STRUCTURE_TYPES.byNameCodec().dispatch(Structure::type, StructureType::codec);
    public static final Codec<Holder<Structure>> CODEC = RegistryFileCodec.create(IRegistry.STRUCTURE_REGISTRY, DIRECT_CODEC);
    protected final c settings;

    public static <S extends Structure> RecordCodecBuilder<S, c> settingsCodec(RecordCodecBuilder.Instance<S> var02) {
        return c.CODEC.forGetter(var0 -> var0.settings);
    }

    public static <S extends Structure> Codec<S> simpleCodec(Function<c, S> var0) {
        return RecordCodecBuilder.create(var1 -> var1.group(Structure.settingsCodec(var1)).apply((Applicative)var1, var0));
    }

    protected Structure(c var0) {
        this.settings = var0;
    }

    public HolderSet<BiomeBase> biomes() {
        return this.settings.biomes;
    }

    public Map<EnumCreatureType, StructureSpawnOverride> spawnOverrides() {
        return this.settings.spawnOverrides;
    }

    public WorldGenStage.Decoration step() {
        return this.settings.step;
    }

    public TerrainAdjustment terrainAdaptation() {
        return this.settings.terrainAdaptation;
    }

    public StructureBoundingBox adjustBoundingBox(StructureBoundingBox var0) {
        if (this.terrainAdaptation() != TerrainAdjustment.NONE) {
            return var0.inflatedBy(12);
        }
        return var0;
    }

    public StructureStart generate(IRegistryCustom var0, ChunkGenerator var1, WorldChunkManager var2, RandomState var3, StructureTemplateManager var4, long var5, ChunkCoordIntPair var7, int var8, LevelHeightAccessor var9, Predicate<Holder<BiomeBase>> var10) {
        StructurePiecesBuilder var12;
        StructureStart var13;
        Optional<b> var11 = this.findGenerationPoint(new a(var0, var1, var2, var3, var4, var5, var7, var9, var10));
        if (var11.isPresent() && Structure.isValidBiome(var11.get(), var1, var3, var10) && (var13 = new StructureStart(this, var7, var8, (var12 = var11.get().getPiecesBuilder()).build())).isValid()) {
            return var13;
        }
        return StructureStart.INVALID_START;
    }

    protected static Optional<b> onTopOfChunkCenter(a var0, HeightMap.Type var1, Consumer<StructurePiecesBuilder> var2) {
        ChunkCoordIntPair var3 = var0.chunkPos();
        int var4 = var3.getMiddleBlockX();
        int var5 = var3.getMiddleBlockZ();
        int var6 = var0.chunkGenerator().getFirstOccupiedHeight(var4, var5, var1, var0.heightAccessor(), var0.randomState());
        return Optional.of(new b(new BlockPosition(var4, var6, var5), var2));
    }

    private static boolean isValidBiome(b var0, ChunkGenerator var1, RandomState var2, Predicate<Holder<BiomeBase>> var3) {
        BlockPosition var4 = var0.position();
        return var3.test(var1.getBiomeSource().getNoiseBiome(QuartPos.fromBlock(var4.getX()), QuartPos.fromBlock(var4.getY()), QuartPos.fromBlock(var4.getZ()), var2.sampler()));
    }

    public void afterPlace(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, PiecesContainer var6) {
    }

    private static int[] getCornerHeights(a var0, int var1, int var2, int var3, int var4) {
        ChunkGenerator var5 = var0.chunkGenerator();
        LevelHeightAccessor var6 = var0.heightAccessor();
        RandomState var7 = var0.randomState();
        return new int[]{var5.getFirstOccupiedHeight(var1, var3, HeightMap.Type.WORLD_SURFACE_WG, var6, var7), var5.getFirstOccupiedHeight(var1, var3 + var4, HeightMap.Type.WORLD_SURFACE_WG, var6, var7), var5.getFirstOccupiedHeight(var1 + var2, var3, HeightMap.Type.WORLD_SURFACE_WG, var6, var7), var5.getFirstOccupiedHeight(var1 + var2, var3 + var4, HeightMap.Type.WORLD_SURFACE_WG, var6, var7)};
    }

    protected static int getLowestY(a var0, int var1, int var2) {
        ChunkCoordIntPair var3 = var0.chunkPos();
        int var4 = var3.getMinBlockX();
        int var5 = var3.getMinBlockZ();
        return Structure.getLowestY(var0, var4, var5, var1, var2);
    }

    protected static int getLowestY(a var0, int var1, int var2, int var3, int var4) {
        int[] var5 = Structure.getCornerHeights(var0, var1, var3, var2, var4);
        return Math.min(Math.min(var5[0], var5[1]), Math.min(var5[2], var5[3]));
    }

    @Deprecated
    protected BlockPosition getLowestYIn5by5BoxOffset7Blocks(a var0, EnumBlockRotation var1) {
        int var2 = 5;
        int var3 = 5;
        if (var1 == EnumBlockRotation.CLOCKWISE_90) {
            var2 = -5;
        } else if (var1 == EnumBlockRotation.CLOCKWISE_180) {
            var2 = -5;
            var3 = -5;
        } else if (var1 == EnumBlockRotation.COUNTERCLOCKWISE_90) {
            var3 = -5;
        }
        ChunkCoordIntPair var4 = var0.chunkPos();
        int var5 = var4.getBlockX(7);
        int var6 = var4.getBlockZ(7);
        return new BlockPosition(var5, Structure.getLowestY(var0, var5, var6, var2, var3), var6);
    }

    public abstract Optional<b> findGenerationPoint(a var1);

    public abstract StructureType<?> type();

    public static final class c
    extends Record {
        final HolderSet<BiomeBase> biomes;
        final Map<EnumCreatureType, StructureSpawnOverride> spawnOverrides;
        final WorldGenStage.Decoration step;
        final TerrainAdjustment terrainAdaptation;
        public static final MapCodec<c> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)RegistryCodecs.homogeneousList(IRegistry.BIOME_REGISTRY).fieldOf("biomes").forGetter(c::biomes), (App)Codec.simpleMap(EnumCreatureType.CODEC, StructureSpawnOverride.CODEC, (Keyable)INamable.keys(EnumCreatureType.values())).fieldOf("spawn_overrides").forGetter(c::spawnOverrides), (App)WorldGenStage.Decoration.CODEC.fieldOf("step").forGetter(c::step), (App)TerrainAdjustment.CODEC.optionalFieldOf("terrain_adaptation", (Object)TerrainAdjustment.NONE).forGetter(c::terrainAdaptation)).apply((Applicative)var0, c::new));

        public c(HolderSet<BiomeBase> var0, Map<EnumCreatureType, StructureSpawnOverride> var1, WorldGenStage.Decoration var2, TerrainAdjustment var3) {
            this.biomes = var0;
            this.spawnOverrides = var1;
            this.step = var2;
            this.terrainAdaptation = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "biomes;spawnOverrides;step;terrainAdaptation", "biomes", "spawnOverrides", "step", "terrainAdaptation"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "biomes;spawnOverrides;step;terrainAdaptation", "biomes", "spawnOverrides", "step", "terrainAdaptation"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "biomes;spawnOverrides;step;terrainAdaptation", "biomes", "spawnOverrides", "step", "terrainAdaptation"}, this, var0);
        }

        public HolderSet<BiomeBase> biomes() {
            return this.biomes;
        }

        public Map<EnumCreatureType, StructureSpawnOverride> spawnOverrides() {
            return this.spawnOverrides;
        }

        public WorldGenStage.Decoration step() {
            return this.step;
        }

        public TerrainAdjustment terrainAdaptation() {
            return this.terrainAdaptation;
        }
    }

    public record a(IRegistryCustom registryAccess, ChunkGenerator chunkGenerator, WorldChunkManager biomeSource, RandomState randomState, StructureTemplateManager structureTemplateManager, SeededRandom random, long seed, ChunkCoordIntPair chunkPos, LevelHeightAccessor heightAccessor, Predicate<Holder<BiomeBase>> validBiome) {
        public a(IRegistryCustom var0, ChunkGenerator var1, WorldChunkManager var2, RandomState var3, StructureTemplateManager var4, long var5, ChunkCoordIntPair var7, LevelHeightAccessor var8, Predicate<Holder<BiomeBase>> var9) {
            this(var0, var1, var2, var3, var4, a.makeRandom(var5, var7), var5, var7, var8, var9);
        }

        private static SeededRandom makeRandom(long var0, ChunkCoordIntPair var2) {
            SeededRandom var3 = new SeededRandom(new LegacyRandomSource(0L));
            var3.setLargeFeatureSeed(var0, var2.x, var2.z);
            return var3;
        }
    }

    public record b(BlockPosition position, Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder> generator) {
        public b(BlockPosition var0, Consumer<StructurePiecesBuilder> var1) {
            this(var0, (Either<Consumer<StructurePiecesBuilder>, StructurePiecesBuilder>)Either.left(var1));
        }

        public StructurePiecesBuilder getPiecesBuilder() {
            return (StructurePiecesBuilder)this.generator.map(var0 -> {
                StructurePiecesBuilder var1 = new StructurePiecesBuilder();
                var0.accept(var1);
                return var1;
            }, var0 -> var0);
        }
    }
}

