/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;

public abstract class TrunkPlacer {
    public static final Codec<TrunkPlacer> CODEC = IRegistry.TRUNK_PLACER_TYPES.byNameCodec().dispatch(TrunkPlacer::type, TrunkPlacers::codec);
    private static final int MAX_BASE_HEIGHT = 32;
    private static final int MAX_RAND = 24;
    public static final int MAX_HEIGHT = 80;
    protected final int baseHeight;
    protected final int heightRandA;
    protected final int heightRandB;

    protected static <P extends TrunkPlacer> Products.P3<RecordCodecBuilder.Mu<P>, Integer, Integer, Integer> trunkPlacerParts(RecordCodecBuilder.Instance<P> var02) {
        return var02.group((App)Codec.intRange((int)0, (int)32).fieldOf("base_height").forGetter(var0 -> var0.baseHeight), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(var0 -> var0.heightRandA), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_b").forGetter(var0 -> var0.heightRandB));
    }

    public TrunkPlacer(int var0, int var1, int var2) {
        this.baseHeight = var0;
        this.heightRandA = var1;
        this.heightRandB = var2;
    }

    protected abstract TrunkPlacers<?> type();

    public abstract List<WorldGenFoilagePlacer.a> placeTrunk(VirtualLevelReadable var1, BiConsumer<BlockPosition, IBlockData> var2, RandomSource var3, int var4, BlockPosition var5, WorldGenFeatureTreeConfiguration var6);

    public int getTreeHeight(RandomSource var0) {
        return this.baseHeight + var0.nextInt(this.heightRandA + 1) + var0.nextInt(this.heightRandB + 1);
    }

    private static boolean isDirt(VirtualLevelReadable var02, BlockPosition var1) {
        return var02.isStateAtPosition(var1, var0 -> WorldGenerator.isDirt(var0) && !var0.is(Blocks.GRASS_BLOCK) && !var0.is(Blocks.MYCELIUM));
    }

    protected static void setDirtAt(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, RandomSource var2, BlockPosition var3, WorldGenFeatureTreeConfiguration var4) {
        if (var4.forceDirt || !TrunkPlacer.isDirt(var0, var3)) {
            var1.accept(var3, var4.dirtProvider.getState(var2, var3));
        }
    }

    protected boolean placeLog(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, RandomSource var2, BlockPosition var3, WorldGenFeatureTreeConfiguration var4) {
        return this.placeLog(var0, var1, var2, var3, var4, Function.identity());
    }

    protected boolean placeLog(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, RandomSource var2, BlockPosition var3, WorldGenFeatureTreeConfiguration var4, Function<IBlockData, IBlockData> var5) {
        if (this.validTreePos(var0, var3)) {
            var1.accept(var3, var5.apply(var4.trunkProvider.getState(var2, var3)));
            return true;
        }
        return false;
    }

    protected void placeLogIfFree(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, RandomSource var2, BlockPosition.MutableBlockPosition var3, WorldGenFeatureTreeConfiguration var4) {
        if (this.isFree(var0, var3)) {
            this.placeLog(var0, var1, var2, var3, var4);
        }
    }

    protected boolean validTreePos(VirtualLevelReadable var0, BlockPosition var1) {
        return WorldGenTrees.validTreePos(var0, var1);
    }

    public boolean isFree(VirtualLevelReadable var02, BlockPosition var1) {
        return this.validTreePos(var02, var1) || var02.isStateAtPosition(var1, var0 -> var0.is(TagsBlock.LOGS));
    }
}

