/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.configurations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;

public class MultifaceGrowthConfiguration
implements WorldGenFeatureConfiguration {
    public static final Codec<MultifaceGrowthConfiguration> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)IRegistry.BLOCK.byNameCodec().fieldOf("block").flatXmap(MultifaceGrowthConfiguration::apply, DataResult::success).orElse((Object)((MultifaceBlock)Blocks.GLOW_LICHEN)).forGetter(var0 -> var0.placeBlock), (App)Codec.intRange((int)1, (int)64).fieldOf("search_range").orElse((Object)10).forGetter(var0 -> var0.searchRange), (App)Codec.BOOL.fieldOf("can_place_on_floor").orElse((Object)false).forGetter(var0 -> var0.canPlaceOnFloor), (App)Codec.BOOL.fieldOf("can_place_on_ceiling").orElse((Object)false).forGetter(var0 -> var0.canPlaceOnCeiling), (App)Codec.BOOL.fieldOf("can_place_on_wall").orElse((Object)false).forGetter(var0 -> var0.canPlaceOnWall), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_spreading").orElse((Object)Float.valueOf(0.5f)).forGetter(var0 -> Float.valueOf(var0.chanceOfSpreading)), (App)RegistryCodecs.homogeneousList(IRegistry.BLOCK_REGISTRY).fieldOf("can_be_placed_on").forGetter(var0 -> var0.canBePlacedOn)).apply((Applicative)var02, MultifaceGrowthConfiguration::new));
    public final MultifaceBlock placeBlock;
    public final int searchRange;
    public final boolean canPlaceOnFloor;
    public final boolean canPlaceOnCeiling;
    public final boolean canPlaceOnWall;
    public final float chanceOfSpreading;
    public final HolderSet<Block> canBePlacedOn;
    private final ObjectArrayList<EnumDirection> validDirections;

    private static DataResult<MultifaceBlock> apply(Block var0) {
        DataResult dataResult;
        if (var0 instanceof MultifaceBlock) {
            MultifaceBlock var1 = (MultifaceBlock)var0;
            dataResult = DataResult.success((Object)var1);
        } else {
            dataResult = DataResult.error((String)"Growth block should be a multiface block");
        }
        return dataResult;
    }

    public MultifaceGrowthConfiguration(MultifaceBlock var0, int var1, boolean var2, boolean var3, boolean var4, float var5, HolderSet<Block> var6) {
        this.placeBlock = var0;
        this.searchRange = var1;
        this.canPlaceOnFloor = var2;
        this.canPlaceOnCeiling = var3;
        this.canPlaceOnWall = var4;
        this.chanceOfSpreading = var5;
        this.canBePlacedOn = var6;
        this.validDirections = new ObjectArrayList(6);
        if (var3) {
            this.validDirections.add((Object)EnumDirection.UP);
        }
        if (var2) {
            this.validDirections.add((Object)EnumDirection.DOWN);
        }
        if (var4) {
            EnumDirection.EnumDirectionLimit.HORIZONTAL.forEach(arg_0 -> this.validDirections.add(arg_0));
        }
    }

    public List<EnumDirection> getShuffledDirectionsExcept(RandomSource var0, EnumDirection var12) {
        return SystemUtils.toShuffledList(this.validDirections.stream().filter(var1 -> var1 != var12), var0);
    }

    public List<EnumDirection> getShuffledDirections(RandomSource var0) {
        return SystemUtils.shuffledCopy(this.validDirections, var0);
    }
}

