/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;

public class WorldGenEndTrophy
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    public static final int PODIUM_RADIUS = 4;
    public static final int PODIUM_PILLAR_HEIGHT = 4;
    public static final int RIM_RADIUS = 1;
    public static final float CORNER_ROUNDING = 0.5f;
    public static final BlockPosition END_PODIUM_LOCATION = BlockPosition.ZERO;
    private final boolean active;

    public WorldGenEndTrophy(boolean var0) {
        super(WorldGenFeatureEmptyConfiguration.CODEC);
        this.active = var0;
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> var0) {
        BlockPosition var1 = var0.origin();
        GeneratorAccessSeed var2 = var0.level();
        for (BlockPosition var4 : BlockPosition.betweenClosed(new BlockPosition(var1.getX() - 4, var1.getY() - 1, var1.getZ() - 4), new BlockPosition(var1.getX() + 4, var1.getY() + 32, var1.getZ() + 4))) {
            boolean var5 = var4.closerThan(var1, 2.5);
            if (!var5 && !var4.closerThan(var1, 3.5)) continue;
            if (var4.getY() < var1.getY()) {
                if (var5) {
                    this.setBlock(var2, var4, Blocks.BEDROCK.defaultBlockState());
                    continue;
                }
                if (var4.getY() >= var1.getY()) continue;
                this.setBlock(var2, var4, Blocks.END_STONE.defaultBlockState());
                continue;
            }
            if (var4.getY() > var1.getY()) {
                this.setBlock(var2, var4, Blocks.AIR.defaultBlockState());
                continue;
            }
            if (!var5) {
                this.setBlock(var2, var4, Blocks.BEDROCK.defaultBlockState());
                continue;
            }
            if (this.active) {
                this.setBlock(var2, new BlockPosition(var4), Blocks.END_PORTAL.defaultBlockState());
                continue;
            }
            this.setBlock(var2, new BlockPosition(var4), Blocks.AIR.defaultBlockState());
        }
        for (int var3 = 0; var3 < 4; ++var3) {
            this.setBlock(var2, var1.above(var3), Blocks.BEDROCK.defaultBlockState());
        }
        BlockPosition var3 = var1.above(2);
        for (EnumDirection var5 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            this.setBlock(var2, var3.relative(var5), (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, var5));
        }
        return true;
    }
}

