/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public class VibrationListener
implements GameEventListener {
    protected final PositionSource listenerSource;
    protected final int listenerRange;
    protected final b config;
    @Nullable
    protected a receivingEvent;
    protected float receivingDistance;
    protected int travelTimeInTicks;

    public static Codec<VibrationListener> codec(b var0) {
        return RecordCodecBuilder.create(var12 -> var12.group((App)PositionSource.CODEC.fieldOf("source").forGetter(var0 -> var0.listenerSource), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("range").forGetter(var0 -> var0.listenerRange), (App)a.CODEC.optionalFieldOf("event").forGetter(var0 -> Optional.ofNullable(var0.receivingEvent)), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("event_distance").orElse((Object)Float.valueOf(0.0f)).forGetter(var0 -> Float.valueOf(var0.receivingDistance)), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("event_delay").orElse((Object)0).forGetter(var0 -> var0.travelTimeInTicks)).apply((Applicative)var12, (var1, var2, var3, var4, var5) -> new VibrationListener((PositionSource)var1, (int)var2, var0, var3.orElse(null), var4.floatValue(), (int)var5)));
    }

    public VibrationListener(PositionSource var0, int var1, b var2, @Nullable a var3, float var4, int var5) {
        this.listenerSource = var0;
        this.listenerRange = var1;
        this.config = var2;
        this.receivingEvent = var3;
        this.receivingDistance = var4;
        this.travelTimeInTicks = var5;
    }

    public void tick(World var0) {
        if (var0 instanceof WorldServer) {
            WorldServer var1 = (WorldServer)var0;
            if (this.receivingEvent != null) {
                --this.travelTimeInTicks;
                if (this.travelTimeInTicks <= 0) {
                    this.travelTimeInTicks = 0;
                    this.config.onSignalReceive(var1, this, new BlockPosition(this.receivingEvent.pos), this.receivingEvent.gameEvent, this.receivingEvent.getEntity(var1).orElse(null), this.receivingEvent.getProjectileOwner(var1).orElse(null), this.receivingDistance);
                    this.receivingEvent = null;
                }
            }
        }
    }

    @Override
    public PositionSource getListenerSource() {
        return this.listenerSource;
    }

    @Override
    public int getListenerRadius() {
        return this.listenerRange;
    }

    @Override
    public boolean handleGameEvent(WorldServer var0, GameEvent.b var1) {
        GameEvent.a var3;
        if (this.receivingEvent != null) {
            return false;
        }
        GameEvent var2 = var1.gameEvent();
        if (!this.config.isValidVibration(var2, var3 = var1.context())) {
            return false;
        }
        Optional<Vec3D> var4 = this.listenerSource.getPosition(var0);
        if (var4.isEmpty()) {
            return false;
        }
        Vec3D var5 = var1.source();
        Vec3D var6 = var4.get();
        if (!this.config.shouldListen(var0, this, new BlockPosition(var5), var2, var3)) {
            return false;
        }
        if (VibrationListener.isOccluded(var0, var5, var6)) {
            return false;
        }
        this.scheduleSignal(var0, var2, var3, var5, var6);
        return true;
    }

    private void scheduleSignal(WorldServer var0, GameEvent var1, GameEvent.a var2, Vec3D var3, Vec3D var4) {
        this.receivingDistance = (float)var3.distanceTo(var4);
        this.receivingEvent = new a(var1, this.receivingDistance, var3, var2.sourceEntity());
        this.travelTimeInTicks = MathHelper.floor(this.receivingDistance);
        var0.sendParticles(new VibrationParticleOption(this.listenerSource, this.travelTimeInTicks), var3.x, var3.y, var3.z, 1, 0.0, 0.0, 0.0, 0.0);
        this.config.onSignalSchedule();
    }

    private static boolean isOccluded(World var02, Vec3D var1, Vec3D var2) {
        Vec3D var3 = new Vec3D((double)MathHelper.floor(var1.x) + 0.5, (double)MathHelper.floor(var1.y) + 0.5, (double)MathHelper.floor(var1.z) + 0.5);
        Vec3D var4 = new Vec3D((double)MathHelper.floor(var2.x) + 0.5, (double)MathHelper.floor(var2.y) + 0.5, (double)MathHelper.floor(var2.z) + 0.5);
        for (EnumDirection var8 : EnumDirection.values()) {
            Vec3D var9 = var3.relative(var8, 1.0E-5f);
            if (var02.isBlockInLine(new ClipBlockStateContext(var9, var4, var0 -> var0.is(TagsBlock.OCCLUDES_VIBRATION_SIGNALS))).getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) continue;
            return false;
        }
        return true;
    }

    public static interface b {
        default public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.VIBRATIONS;
        }

        default public boolean canTriggerAvoidVibration() {
            return false;
        }

        default public boolean isValidVibration(GameEvent var0, GameEvent.a var1) {
            if (!var0.is(this.getListenableEvents())) {
                return false;
            }
            Entity var2 = var1.sourceEntity();
            if (var2 != null) {
                if (var2.isSpectator()) {
                    return false;
                }
                if (var2.isSteppingCarefully() && var0.is(GameEventTags.IGNORE_VIBRATIONS_SNEAKING)) {
                    if (this.canTriggerAvoidVibration() && var2 instanceof EntityPlayer) {
                        EntityPlayer var3 = (EntityPlayer)var2;
                        CriterionTriggers.AVOID_VIBRATION.trigger(var3);
                    }
                    return false;
                }
                if (var2.dampensVibrations()) {
                    return false;
                }
            }
            if (var1.affectedState() != null) {
                return !var1.affectedState().is(TagsBlock.DAMPENS_VIBRATIONS);
            }
            return true;
        }

        public boolean shouldListen(WorldServer var1, GameEventListener var2, BlockPosition var3, GameEvent var4, GameEvent.a var5);

        public void onSignalReceive(WorldServer var1, GameEventListener var2, BlockPosition var3, GameEvent var4, @Nullable Entity var5, @Nullable Entity var6, float var7);

        default public void onSignalSchedule() {
        }
    }

    public static final class a
    extends Record {
        final GameEvent gameEvent;
        private final float distance;
        final Vec3D pos;
        @Nullable
        private final UUID uuid;
        @Nullable
        private final UUID projectileOwnerUuid;
        @Nullable
        private final Entity entity;
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)IRegistry.GAME_EVENT.byNameCodec().fieldOf("game_event").forGetter(a::gameEvent), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("distance").forGetter(a::distance), (App)Vec3D.CODEC.fieldOf("pos").forGetter(a::pos), (App)ExtraCodecs.UUID.optionalFieldOf("source").forGetter(var0 -> Optional.ofNullable(var0.uuid())), (App)ExtraCodecs.UUID.optionalFieldOf("projectile_owner").forGetter(var0 -> Optional.ofNullable(var0.projectileOwnerUuid()))).apply((Applicative)var02, (var0, var1, var2, var3, var4) -> new a((GameEvent)var0, var1.floatValue(), (Vec3D)var2, var3.orElse(null), var4.orElse(null))));

        public a(GameEvent var0, float var1, Vec3D var2, @Nullable UUID var3, @Nullable UUID var4) {
            this(var0, var1, var2, var3, var4, null);
        }

        public a(GameEvent var0, float var1, Vec3D var2, @Nullable Entity var3) {
            this(var0, var1, var2, var3 == null ? null : var3.getUUID(), a.getProjectileOwner(var3), var3);
        }

        public a(GameEvent var0, float var1, Vec3D var2, @Nullable UUID var3, @Nullable UUID var4, @Nullable Entity var5) {
            this.gameEvent = var0;
            this.distance = var1;
            this.pos = var2;
            this.uuid = var3;
            this.projectileOwnerUuid = var4;
            this.entity = var5;
        }

        @Nullable
        private static UUID getProjectileOwner(@Nullable Entity var0) {
            IProjectile var1;
            if (var0 instanceof IProjectile && (var1 = (IProjectile)var0).getOwner() != null) {
                return var1.getOwner().getUUID();
            }
            return null;
        }

        public Optional<Entity> getEntity(WorldServer var0) {
            return Optional.ofNullable(this.entity).or(() -> Optional.ofNullable(this.uuid).map(var0::getEntity));
        }

        public Optional<Entity> getProjectileOwner(WorldServer var02) {
            return this.getEntity(var02).filter(var0 -> var0 instanceof IProjectile).map(var0 -> (IProjectile)var0).map(IProjectile::getOwner).or(() -> Optional.ofNullable(this.projectileOwnerUuid).map(var02::getEntity));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "gameEvent;distance;pos;uuid;projectileOwnerUuid;entity", "gameEvent", "distance", "pos", "uuid", "projectileOwnerUuid", "entity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "gameEvent;distance;pos;uuid;projectileOwnerUuid;entity", "gameEvent", "distance", "pos", "uuid", "projectileOwnerUuid", "entity"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "gameEvent;distance;pos;uuid;projectileOwnerUuid;entity", "gameEvent", "distance", "pos", "uuid", "projectileOwnerUuid", "entity"}, this, var0);
        }

        public GameEvent gameEvent() {
            return this.gameEvent;
        }

        public float distance() {
            return this.distance;
        }

        public Vec3D pos() {
            return this.pos;
        }

        @Nullable
        public UUID uuid() {
            return this.uuid;
        }

        @Nullable
        public UUID projectileOwnerUuid() {
            return this.projectileOwnerUuid;
        }

        @Nullable
        public Entity entity() {
            return this.entity;
        }
    }
}

