/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.IOWorker;
import org.slf4j.Logger;

public class RegionFileSection<R>
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String SECTIONS_TAG = "Sections";
    private final IOWorker worker;
    private final Long2ObjectMap<Optional<R>> storage = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet dirty = new LongLinkedOpenHashSet();
    private final Function<Runnable, Codec<R>> codec;
    private final Function<Runnable, R> factory;
    private final DataFixer fixerUpper;
    private final DataFixTypes type;
    private final IRegistryCustom registryAccess;
    protected final LevelHeightAccessor levelHeightAccessor;

    public RegionFileSection(Path var0, Function<Runnable, Codec<R>> var1, Function<Runnable, R> var2, DataFixer var3, DataFixTypes var4, boolean var5, IRegistryCustom var6, LevelHeightAccessor var7) {
        this.codec = var1;
        this.factory = var2;
        this.fixerUpper = var3;
        this.type = var4;
        this.registryAccess = var6;
        this.levelHeightAccessor = var7;
        this.worker = new IOWorker(var0, var5, var0.getFileName().toString());
    }

    protected void tick(BooleanSupplier var0) {
        while (this.hasWork() && var0.getAsBoolean()) {
            ChunkCoordIntPair var1 = SectionPosition.of(this.dirty.firstLong()).chunk();
            this.writeColumn(var1);
        }
    }

    public boolean hasWork() {
        return !this.dirty.isEmpty();
    }

    @Nullable
    protected Optional<R> get(long var0) {
        return (Optional)this.storage.get(var0);
    }

    protected Optional<R> getOrLoad(long var0) {
        if (this.outsideStoredRange(var0)) {
            return Optional.empty();
        }
        Optional<R> var2 = this.get(var0);
        if (var2 != null) {
            return var2;
        }
        this.readColumn(SectionPosition.of(var0).chunk());
        var2 = this.get(var0);
        if (var2 == null) {
            throw SystemUtils.pauseInIde(new IllegalStateException());
        }
        return var2;
    }

    protected boolean outsideStoredRange(long var0) {
        int var2 = SectionPosition.sectionToBlockCoord(SectionPosition.y(var0));
        return this.levelHeightAccessor.isOutsideBuildHeight(var2);
    }

    protected R getOrCreate(long var0) {
        if (this.outsideStoredRange(var0)) {
            throw SystemUtils.pauseInIde(new IllegalArgumentException("sectionPos out of bounds"));
        }
        Optional<R> var2 = this.getOrLoad(var0);
        if (var2.isPresent()) {
            return var2.get();
        }
        R var3 = this.factory.apply(() -> this.setDirty(var0));
        this.storage.put(var0, Optional.of(var3));
        return var3;
    }

    private void readColumn(ChunkCoordIntPair var0) {
        Optional<NBTTagCompound> var1 = this.tryRead(var0).join();
        RegistryOps<NBTBase> var2 = RegistryOps.create(DynamicOpsNBT.INSTANCE, this.registryAccess);
        this.readColumn(var0, var2, var1.orElse(null));
    }

    private CompletableFuture<Optional<NBTTagCompound>> tryRead(ChunkCoordIntPair var0) {
        return this.worker.loadAsync(var0).exceptionally(var1 -> {
            if (var1 instanceof IOException) {
                IOException var2 = (IOException)var1;
                LOGGER.error("Error reading chunk {} data from disk", (Object)var0, (Object)var2);
                return Optional.empty();
            }
            throw new CompletionException((Throwable)var1);
        });
    }

    private <T> void readColumn(ChunkCoordIntPair var0, DynamicOps<T> var1, @Nullable T var22) {
        if (var22 == null) {
            for (int var32 = this.levelHeightAccessor.getMinSection(); var32 < this.levelHeightAccessor.getMaxSection(); ++var32) {
                this.storage.put(RegionFileSection.getKey(var0, var32), Optional.empty());
            }
        } else {
            int var5;
            Dynamic var33 = new Dynamic(var1, var22);
            int var4 = RegionFileSection.getVersion(var33);
            boolean var6 = var4 != (var5 = SharedConstants.getCurrentVersion().getWorldVersion());
            Dynamic var7 = this.fixerUpper.update(this.type.getType(), var33, var4, var5);
            OptionalDynamic var8 = var7.get(SECTIONS_TAG);
            for (int var9 = this.levelHeightAccessor.getMinSection(); var9 < this.levelHeightAccessor.getMaxSection(); ++var9) {
                long var10 = RegionFileSection.getKey(var0, var9);
                Optional var12 = var8.get(Integer.toString(var9)).result().flatMap(var2 -> this.codec.apply(() -> this.setDirty(var10)).parse(var2).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)));
                this.storage.put(var10, var12);
                var12.ifPresent(var3 -> {
                    this.onSectionLoad(var10);
                    if (var6) {
                        this.setDirty(var10);
                    }
                });
            }
        }
    }

    private void writeColumn(ChunkCoordIntPair var0) {
        RegistryOps<NBTBase> var1 = RegistryOps.create(DynamicOpsNBT.INSTANCE, this.registryAccess);
        Dynamic<NBTBase> var2 = this.writeColumn(var0, var1);
        NBTBase var3 = (NBTBase)var2.getValue();
        if (var3 instanceof NBTTagCompound) {
            this.worker.store(var0, (NBTTagCompound)var3);
        } else {
            LOGGER.error("Expected compound tag, got {}", (Object)var3);
        }
    }

    private <T> Dynamic<T> writeColumn(ChunkCoordIntPair var0, DynamicOps<T> var1) {
        HashMap var2 = Maps.newHashMap();
        for (int var32 = this.levelHeightAccessor.getMinSection(); var32 < this.levelHeightAccessor.getMaxSection(); ++var32) {
            long var4 = RegionFileSection.getKey(var0, var32);
            this.dirty.remove(var4);
            Optional var6 = (Optional)this.storage.get(var4);
            if (var6 == null || !var6.isPresent()) continue;
            DataResult var7 = this.codec.apply(() -> this.setDirty(var4)).encodeStart(var1, var6.get());
            String var8 = Integer.toString(var32);
            var7.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var3 -> var2.put(var1.createString(var8), var3));
        }
        return new Dynamic(var1, var1.createMap((Map)ImmutableMap.of((Object)var1.createString(SECTIONS_TAG), (Object)var1.createMap((Map)var2), (Object)var1.createString("DataVersion"), (Object)var1.createInt(SharedConstants.getCurrentVersion().getWorldVersion()))));
    }

    private static long getKey(ChunkCoordIntPair var0, int var1) {
        return SectionPosition.asLong(var0.x, var1, var0.z);
    }

    protected void onSectionLoad(long var0) {
    }

    protected void setDirty(long var0) {
        Optional var2 = (Optional)this.storage.get(var0);
        if (var2 == null || !var2.isPresent()) {
            LOGGER.warn("No data for position: {}", (Object)SectionPosition.of(var0));
            return;
        }
        this.dirty.add(var0);
    }

    private static int getVersion(Dynamic<?> var0) {
        return var0.get("DataVersion").asInt(1945);
    }

    public void flush(ChunkCoordIntPair var0) {
        if (this.hasWork()) {
            for (int var1 = this.levelHeightAccessor.getMinSection(); var1 < this.levelHeightAccessor.getMaxSection(); ++var1) {
                long var2 = RegionFileSection.getKey(var0, var1);
                if (!this.dirty.contains(var2)) continue;
                this.writeColumn(var0);
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.worker.close();
    }
}

