/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import net.minecraft.world.ticks.TickContainerAccess;

public class ProtoChunk
extends IChunkAccess {
    @Nullable
    private volatile LightEngine lightEngine;
    private volatile ChunkStatus status = ChunkStatus.EMPTY;
    private final List<NBTTagCompound> entities = Lists.newArrayList();
    private final List<BlockPosition> lights = Lists.newArrayList();
    private final Map<WorldGenStage.Features, CarvingMask> carvingMasks = new Object2ObjectArrayMap();
    @Nullable
    private BelowZeroRetrogen belowZeroRetrogen;
    private final ProtoChunkTickList<Block> blockTicks;
    private final ProtoChunkTickList<FluidType> fluidTicks;

    public ProtoChunk(ChunkCoordIntPair var0, ChunkConverter var1, LevelHeightAccessor var2, IRegistry<BiomeBase> var3, @Nullable BlendingData var4) {
        this(var0, var1, null, new ProtoChunkTickList<Block>(), new ProtoChunkTickList<FluidType>(), var2, var3, var4);
    }

    public ProtoChunk(ChunkCoordIntPair var0, ChunkConverter var1, @Nullable ChunkSection[] var2, ProtoChunkTickList<Block> var3, ProtoChunkTickList<FluidType> var4, LevelHeightAccessor var5, IRegistry<BiomeBase> var6, @Nullable BlendingData var7) {
        super(var0, var1, var5, var6, 0L, var2, var7);
        this.blockTicks = var3;
        this.fluidTicks = var4;
    }

    @Override
    public TickContainerAccess<Block> getBlockTicks() {
        return this.blockTicks;
    }

    @Override
    public TickContainerAccess<FluidType> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    public IChunkAccess.a getTicksForSerialization() {
        return new IChunkAccess.a(this.blockTicks, this.fluidTicks);
    }

    @Override
    public IBlockData getBlockState(BlockPosition var0) {
        int var1 = var0.getY();
        if (this.isOutsideBuildHeight(var1)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        ChunkSection var2 = this.getSection(this.getSectionIndex(var1));
        if (var2.hasOnlyAir()) {
            return Blocks.AIR.defaultBlockState();
        }
        return var2.getBlockState(var0.getX() & 0xF, var1 & 0xF, var0.getZ() & 0xF);
    }

    @Override
    public Fluid getFluidState(BlockPosition var0) {
        int var1 = var0.getY();
        if (this.isOutsideBuildHeight(var1)) {
            return FluidTypes.EMPTY.defaultFluidState();
        }
        ChunkSection var2 = this.getSection(this.getSectionIndex(var1));
        if (var2.hasOnlyAir()) {
            return FluidTypes.EMPTY.defaultFluidState();
        }
        return var2.getFluidState(var0.getX() & 0xF, var1 & 0xF, var0.getZ() & 0xF);
    }

    @Override
    public Stream<BlockPosition> getLights() {
        return this.lights.stream();
    }

    public ShortList[] getPackedLights() {
        ShortList[] var0 = new ShortList[this.getSectionsCount()];
        for (BlockPosition var2 : this.lights) {
            IChunkAccess.getOrCreateOffsetList(var0, this.getSectionIndex(var2.getY())).add(ProtoChunk.packOffsetCoordinates(var2));
        }
        return var0;
    }

    public void addLight(short var0, int var1) {
        this.addLight(ProtoChunk.unpackOffsetCoordinates(var0, this.getSectionYFromSectionIndex(var1), this.chunkPos));
    }

    public void addLight(BlockPosition var0) {
        this.lights.add(var0.immutable());
    }

    @Override
    @Nullable
    public IBlockData setBlockState(BlockPosition var0, IBlockData var1, boolean var2) {
        int var3 = var0.getX();
        int var4 = var0.getY();
        int var5 = var0.getZ();
        if (var4 < this.getMinBuildHeight() || var4 >= this.getMaxBuildHeight()) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        int var6 = this.getSectionIndex(var4);
        if (this.sections[var6].hasOnlyAir() && var1.is(Blocks.AIR)) {
            return var1;
        }
        if (var1.getLightEmission() > 0) {
            this.lights.add(new BlockPosition((var3 & 0xF) + this.getPos().getMinBlockX(), var4, (var5 & 0xF) + this.getPos().getMinBlockZ()));
        }
        ChunkSection var7 = this.getSection(var6);
        IBlockData var8 = var7.setBlockState(var3 & 0xF, var4 & 0xF, var5 & 0xF, var1);
        if (this.status.isOrAfter(ChunkStatus.FEATURES) && var1 != var8 && (var1.getLightBlock(this, var0) != var8.getLightBlock(this, var0) || var1.getLightEmission() != var8.getLightEmission() || var1.useShapeForLightOcclusion() || var8.useShapeForLightOcclusion())) {
            this.lightEngine.checkBlock(var0);
        }
        EnumSet<HeightMap.Type> var9 = this.getStatus().heightmapsAfter();
        EnumSet<HeightMap.Type> var10 = null;
        for (HeightMap.Type var12 : var9) {
            HeightMap var13 = (HeightMap)this.heightmaps.get(var12);
            if (var13 != null) continue;
            if (var10 == null) {
                var10 = EnumSet.noneOf(HeightMap.Type.class);
            }
            var10.add(var12);
        }
        if (var10 != null) {
            HeightMap.primeHeightmaps(this, var10);
        }
        for (HeightMap.Type var12 : var9) {
            ((HeightMap)this.heightmaps.get(var12)).update(var3 & 0xF, var4, var5 & 0xF, var1);
        }
        return var8;
    }

    @Override
    public void setBlockEntity(TileEntity var0) {
        this.blockEntities.put(var0.getBlockPos(), var0);
    }

    @Override
    @Nullable
    public TileEntity getBlockEntity(BlockPosition var0) {
        return (TileEntity)this.blockEntities.get(var0);
    }

    public Map<BlockPosition, TileEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public void addEntity(NBTTagCompound var0) {
        this.entities.add(var0);
    }

    @Override
    public void addEntity(Entity var0) {
        if (var0.isPassenger()) {
            return;
        }
        NBTTagCompound var1 = new NBTTagCompound();
        var0.save(var1);
        this.addEntity(var1);
    }

    @Override
    public void setStartForStructure(Structure var0, StructureStart var1) {
        BelowZeroRetrogen var2 = this.getBelowZeroRetrogen();
        if (var2 != null && var1.isValid()) {
            StructureBoundingBox var3 = var1.getBoundingBox();
            LevelHeightAccessor var4 = this.getHeightAccessorForGeneration();
            if (var3.minY() < var4.getMinBuildHeight() || var3.maxY() >= var4.getMaxBuildHeight()) {
                return;
            }
        }
        super.setStartForStructure(var0, var1);
    }

    public List<NBTTagCompound> getEntities() {
        return this.entities;
    }

    @Override
    public ChunkStatus getStatus() {
        return this.status;
    }

    public void setStatus(ChunkStatus var0) {
        this.status = var0;
        if (this.belowZeroRetrogen != null && var0.isOrAfter(this.belowZeroRetrogen.targetStatus())) {
            this.setBelowZeroRetrogen(null);
        }
        this.setUnsaved(true);
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2) {
        if (this.getStatus().isOrAfter(ChunkStatus.BIOMES) || this.belowZeroRetrogen != null && this.belowZeroRetrogen.targetStatus().isOrAfter(ChunkStatus.BIOMES)) {
            return super.getNoiseBiome(var0, var1, var2);
        }
        throw new IllegalStateException("Asking for biomes before we have biomes");
    }

    public static short packOffsetCoordinates(BlockPosition var0) {
        int var1 = var0.getX();
        int var2 = var0.getY();
        int var3 = var0.getZ();
        int var4 = var1 & 0xF;
        int var5 = var2 & 0xF;
        int var6 = var3 & 0xF;
        return (short)(var4 | var5 << 4 | var6 << 8);
    }

    public static BlockPosition unpackOffsetCoordinates(short var0, int var1, ChunkCoordIntPair var2) {
        int var3 = SectionPosition.sectionToBlockCoord(var2.x, var0 & 0xF);
        int var4 = SectionPosition.sectionToBlockCoord(var1, var0 >>> 4 & 0xF);
        int var5 = SectionPosition.sectionToBlockCoord(var2.z, var0 >>> 8 & 0xF);
        return new BlockPosition(var3, var4, var5);
    }

    @Override
    public void markPosForPostprocessing(BlockPosition var0) {
        if (!this.isOutsideBuildHeight(var0)) {
            IChunkAccess.getOrCreateOffsetList(this.postProcessing, this.getSectionIndex(var0.getY())).add(ProtoChunk.packOffsetCoordinates(var0));
        }
    }

    @Override
    public void addPackedPostProcess(short var0, int var1) {
        IChunkAccess.getOrCreateOffsetList(this.postProcessing, var1).add(var0);
    }

    public Map<BlockPosition, NBTTagCompound> getBlockEntityNbts() {
        return Collections.unmodifiableMap(this.pendingBlockEntities);
    }

    @Override
    @Nullable
    public NBTTagCompound getBlockEntityNbtForSaving(BlockPosition var0) {
        TileEntity var1 = this.getBlockEntity(var0);
        if (var1 != null) {
            return var1.saveWithFullMetadata();
        }
        return (NBTTagCompound)this.pendingBlockEntities.get(var0);
    }

    @Override
    public void removeBlockEntity(BlockPosition var0) {
        this.blockEntities.remove(var0);
        this.pendingBlockEntities.remove(var0);
    }

    @Nullable
    public CarvingMask getCarvingMask(WorldGenStage.Features var0) {
        return this.carvingMasks.get(var0);
    }

    public CarvingMask getOrCreateCarvingMask(WorldGenStage.Features var02) {
        return this.carvingMasks.computeIfAbsent(var02, var0 -> new CarvingMask(this.getHeight(), this.getMinBuildHeight()));
    }

    public void setCarvingMask(WorldGenStage.Features var0, CarvingMask var1) {
        this.carvingMasks.put(var0, var1);
    }

    public void setLightEngine(LightEngine var0) {
        this.lightEngine = var0;
    }

    public void setBelowZeroRetrogen(@Nullable BelowZeroRetrogen var0) {
        this.belowZeroRetrogen = var0;
    }

    @Override
    @Nullable
    public BelowZeroRetrogen getBelowZeroRetrogen() {
        return this.belowZeroRetrogen;
    }

    private static <T> LevelChunkTicks<T> unpackTicks(ProtoChunkTickList<T> var0) {
        return new LevelChunkTicks<T>(var0.scheduledTicks());
    }

    public LevelChunkTicks<Block> unpackBlockTicks() {
        return ProtoChunk.unpackTicks(this.blockTicks);
    }

    public LevelChunkTicks<FluidType> unpackFluidTicks() {
        return ProtoChunk.unpackTicks(this.fluidTicks);
    }

    @Override
    public LevelHeightAccessor getHeightAccessorForGeneration() {
        if (this.isUpgrading()) {
            return BelowZeroRetrogen.UPGRADE_HEIGHT_ACCESSOR;
        }
        return this;
    }
}

