/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class SculkShriekerBlockEntity
extends TileEntity
implements VibrationListener.b {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int LISTENER_RADIUS = 8;
    private static final int WARNING_SOUND_RADIUS = 10;
    private static final int WARDEN_SPAWN_ATTEMPTS = 20;
    private static final int WARDEN_SPAWN_RANGE_XZ = 5;
    private static final int WARDEN_SPAWN_RANGE_Y = 6;
    private static final int DARKNESS_RADIUS = 40;
    private static final Int2ObjectMap<SoundEffect> SOUND_BY_LEVEL = (Int2ObjectMap)SystemUtils.make(new Int2ObjectOpenHashMap(), var0 -> {
        var0.put(1, (Object)SoundEffects.WARDEN_NEARBY_CLOSE);
        var0.put(2, (Object)SoundEffects.WARDEN_NEARBY_CLOSER);
        var0.put(3, (Object)SoundEffects.WARDEN_NEARBY_CLOSEST);
        var0.put(4, (Object)SoundEffects.WARDEN_LISTENING_ANGRY);
    });
    private static final int SHRIEKING_TICKS = 90;
    public int warningLevel;
    private VibrationListener listener;

    public SculkShriekerBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SCULK_SHRIEKER, var0, var1);
        this.listener = new VibrationListener(new BlockPositionSource(this.worldPosition), 8, this, null, 0.0f, 0);
    }

    public VibrationListener getListener() {
        return this.listener;
    }

    @Override
    public void load(NBTTagCompound var02) {
        super.load(var02);
        if (var02.contains("warning_level", 99)) {
            this.warningLevel = var02.getInt("warning_level");
        }
        if (var02.contains("listener", 10)) {
            VibrationListener.codec(this).parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.getCompound("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var0 -> {
                this.listener = var0;
            });
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        var0.putInt("warning_level", this.warningLevel);
        VibrationListener.codec(this).encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.listener).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("listener", (NBTBase)var1));
    }

    @Override
    public TagKey<GameEvent> getListenableEvents() {
        return GameEventTags.SHRIEKER_CAN_LISTEN;
    }

    @Override
    public boolean shouldListen(WorldServer var0, GameEventListener var1, BlockPosition var2, GameEvent var3, GameEvent.a var4) {
        return !this.isRemoved() && this.getBlockState().getValue(SculkShriekerBlock.SHRIEKING) == false && SculkShriekerBlockEntity.tryGetPlayer(var4.sourceEntity()) != null;
    }

    @Nullable
    public static EntityPlayer tryGetPlayer(@Nullable Entity var0) {
        IProjectile var1;
        Entity entity;
        Entity entity2;
        if (var0 instanceof EntityPlayer) {
            EntityPlayer var12 = (EntityPlayer)var0;
            return var12;
        }
        if (var0 != null && (entity2 = var0.getControllingPassenger()) instanceof EntityPlayer) {
            EntityPlayer var13 = (EntityPlayer)entity2;
            return var13;
        }
        if (var0 instanceof IProjectile && (entity = (var1 = (IProjectile)var0).getOwner()) instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)entity;
            return var2;
        }
        return null;
    }

    @Override
    public void onSignalReceive(WorldServer var0, GameEventListener var1, BlockPosition var2, GameEvent var3, @Nullable Entity var4, @Nullable Entity var5, float var6) {
        this.tryShriek(var0, SculkShriekerBlockEntity.tryGetPlayer(var5 != null ? var5 : var4));
    }

    public void tryShriek(WorldServer var0, @Nullable EntityPlayer var1) {
        if (var1 == null) {
            return;
        }
        IBlockData var2 = this.getBlockState();
        if (var2.getValue(SculkShriekerBlock.SHRIEKING).booleanValue()) {
            return;
        }
        this.warningLevel = 0;
        if (this.canRespond(var0) && !this.tryToWarn(var0, var1)) {
            return;
        }
        this.shriek(var0, var1);
    }

    private boolean tryToWarn(WorldServer var02, EntityPlayer var1) {
        OptionalInt var2 = WardenSpawnTracker.tryWarn(var02, this.getBlockPos(), var1);
        var2.ifPresent(var0 -> {
            this.warningLevel = var0;
        });
        return var2.isPresent();
    }

    private void shriek(WorldServer var0, @Nullable Entity var1) {
        BlockPosition var2 = this.getBlockPos();
        IBlockData var3 = this.getBlockState();
        var0.setBlock(var2, (IBlockData)var3.setValue(SculkShriekerBlock.SHRIEKING, true), 2);
        var0.scheduleTick(var2, var3.getBlock(), 90);
        var0.levelEvent(3007, var2, 0);
        var0.gameEvent(GameEvent.SHRIEK, var2, GameEvent.a.of(var1));
    }

    private boolean canRespond(WorldServer var0) {
        return this.getBlockState().getValue(SculkShriekerBlock.CAN_SUMMON) != false && var0.getDifficulty() != EnumDifficulty.PEACEFUL && var0.getGameRules().getBoolean(GameRules.RULE_DO_WARDEN_SPAWNING);
    }

    public void tryRespond(WorldServer var0) {
        if (this.canRespond(var0) && this.warningLevel > 0) {
            if (!this.trySummonWarden(var0)) {
                this.playWardenReplySound();
            }
            Warden.applyDarknessAround(var0, Vec3D.atCenterOf(this.getBlockPos()), null, 40);
        }
    }

    private void playWardenReplySound() {
        SoundEffect var0 = (SoundEffect)SOUND_BY_LEVEL.get(this.warningLevel);
        if (var0 != null) {
            BlockPosition var1 = this.getBlockPos();
            int var2 = var1.getX() + MathHelper.randomBetweenInclusive(this.level.random, -10, 10);
            int var3 = var1.getY() + MathHelper.randomBetweenInclusive(this.level.random, -10, 10);
            int var4 = var1.getZ() + MathHelper.randomBetweenInclusive(this.level.random, -10, 10);
            this.level.playSound(null, var2, var3, var4, var0, SoundCategory.HOSTILE, 5.0f, 1.0f);
        }
    }

    private boolean trySummonWarden(WorldServer var0) {
        if (this.warningLevel < 4) {
            return false;
        }
        return SpawnUtil.trySpawnMob(EntityTypes.WARDEN, EnumMobSpawn.TRIGGERED, var0, this.getBlockPos(), 20, 5, 6, SpawnUtil.a.ON_TOP_OF_COLLIDER).isPresent();
    }

    @Override
    public void onSignalSchedule() {
        this.setChanged();
    }
}

