/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class SculkSpreader {
    public static final int MAX_GROWTH_RATE_RADIUS = 24;
    public static final int MAX_CHARGE = 1000;
    public static final float MAX_DECAY_FACTOR = 0.5f;
    private static final int MAX_CURSORS = 32;
    public static final int SHRIEKER_PLACEMENT_RATE = 11;
    final boolean isWorldGeneration;
    private final TagKey<Block> replaceableBlocks;
    private final int growthSpawnCost;
    private final int noGrowthRadius;
    private final int chargeDecayRate;
    private final int additionalDecayRate;
    private List<a> cursors = new ArrayList<a>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public SculkSpreader(boolean var0, TagKey<Block> var1, int var2, int var3, int var4, int var5) {
        this.isWorldGeneration = var0;
        this.replaceableBlocks = var1;
        this.growthSpawnCost = var2;
        this.noGrowthRadius = var3;
        this.chargeDecayRate = var4;
        this.additionalDecayRate = var5;
    }

    public static SculkSpreader createLevelSpreader() {
        return new SculkSpreader(false, TagsBlock.SCULK_REPLACEABLE, 10, 4, 10, 5);
    }

    public static SculkSpreader createWorldGenSpreader() {
        return new SculkSpreader(true, TagsBlock.SCULK_REPLACEABLE_WORLD_GEN, 50, 1, 5, 10);
    }

    public TagKey<Block> replaceableBlocks() {
        return this.replaceableBlocks;
    }

    public int growthSpawnCost() {
        return this.growthSpawnCost;
    }

    public int noGrowthRadius() {
        return this.noGrowthRadius;
    }

    public int chargeDecayRate() {
        return this.chargeDecayRate;
    }

    public int additionalDecayRate() {
        return this.additionalDecayRate;
    }

    public boolean isWorldGeneration() {
        return this.isWorldGeneration;
    }

    @VisibleForTesting
    public List<a> getCursors() {
        return this.cursors;
    }

    public void clear() {
        this.cursors.clear();
    }

    public void load(NBTTagCompound var0) {
        if (var0.contains("cursors", 9)) {
            this.cursors.clear();
            List var1 = a.CODEC.listOf().parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var0.getList("cursors", 10))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(ArrayList::new);
            int var2 = Math.min(var1.size(), 32);
            for (int var3 = 0; var3 < var2; ++var3) {
                this.addCursor((a)var1.get(var3));
            }
        }
    }

    public void save(NBTTagCompound var0) {
        a.CODEC.listOf().encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, this.cursors).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("cursors", (NBTBase)var1));
    }

    public void addCursors(BlockPosition var0, int var1) {
        while (var1 > 0) {
            int var2 = Math.min(var1, 1000);
            this.addCursor(new a(var0, var2));
            var1 -= var2;
        }
    }

    private void addCursor(a var0) {
        if (this.cursors.size() >= 32) {
            return;
        }
        this.cursors.add(var0);
    }

    public void updateCursors(GeneratorAccess var0, BlockPosition var12, RandomSource var22, boolean var3) {
        BlockPosition var9;
        if (this.cursors.isEmpty()) {
            return;
        }
        ArrayList<a> var4 = new ArrayList<a>();
        HashMap<BlockPosition, a> var5 = new HashMap<BlockPosition, a>();
        Object2IntOpenHashMap var6 = new Object2IntOpenHashMap();
        for (a var8 : this.cursors) {
            var8.update(var0, var12, var22, this, var3);
            if (var8.charge <= 0) {
                var0.levelEvent(3006, var8.getPos(), 0);
                continue;
            }
            var9 = var8.getPos();
            var6.computeInt((Object)var9, (var1, var2) -> (var2 == null ? 0 : var2) + var0.charge);
            a var10 = (a)var5.get(var9);
            if (var10 == null) {
                var5.put(var9, var8);
                var4.add(var8);
                continue;
            }
            if (!this.isWorldGeneration() && var8.charge + var10.charge <= 1000) {
                var10.mergeWith(var8);
                continue;
            }
            var4.add(var8);
            if (var8.charge >= var10.charge) continue;
            var5.put(var9, var8);
        }
        for (a var8 : var6.object2IntEntrySet()) {
            Set<EnumDirection> var122;
            var9 = (BlockPosition)var8.getKey();
            int var10 = var8.getIntValue();
            a var11 = (a)var5.get(var9);
            Set<EnumDirection> set = var122 = var11 == null ? null : var11.getFacingData();
            if (var10 <= 0 || var122 == null) continue;
            int var13 = (int)(Math.log1p(var10) / (double)2.3f) + 1;
            int var14 = (var13 << 6) + MultifaceBlock.pack(var122);
            var0.levelEvent(3006, var9, var14);
        }
        this.cursors = var4;
    }

    public static class a {
        private static final ObjectArrayList<BaseBlockPosition> NON_CORNER_NEIGHBOURS = SystemUtils.make(new ObjectArrayList(18), var02 -> BlockPosition.betweenClosedStream(new BlockPosition(-1, -1, -1), new BlockPosition(1, 1, 1)).filter(var0 -> (var0.getX() == 0 || var0.getY() == 0 || var0.getZ() == 0) && !var0.equals(BlockPosition.ZERO)).map(BlockPosition::immutable).forEach(arg_0 -> ((ObjectArrayList)var02).add(arg_0)));
        public static final int MAX_CURSOR_DECAY_DELAY = 1;
        private BlockPosition pos;
        int charge;
        private int updateDelay;
        private int decayDelay;
        @Nullable
        private Set<EnumDirection> facings;
        private static final Codec<Set<EnumDirection>> DIRECTION_SET = EnumDirection.CODEC.listOf().xmap(var0 -> Sets.newEnumSet((Iterable)var0, EnumDirection.class), Lists::newArrayList);
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)BlockPosition.CODEC.fieldOf("pos").forGetter(a::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(a::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(a::getDecayDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(var0 -> var0.updateDelay), (App)DIRECTION_SET.optionalFieldOf("facings").forGetter(var0 -> Optional.ofNullable(var0.getFacingData()))).apply((Applicative)var02, a::new));

        private a(BlockPosition var0, int var1, int var2, int var3, Optional<Set<EnumDirection>> var4) {
            this.pos = var0;
            this.charge = var1;
            this.decayDelay = var2;
            this.updateDelay = var3;
            this.facings = var4.orElse(null);
        }

        public a(BlockPosition var0, int var1) {
            this(var0, var1, 1, 0, Optional.empty());
        }

        public BlockPosition getPos() {
            return this.pos;
        }

        public int getCharge() {
            return this.charge;
        }

        public int getDecayDelay() {
            return this.decayDelay;
        }

        @Nullable
        public Set<EnumDirection> getFacingData() {
            return this.facings;
        }

        private boolean shouldUpdate(GeneratorAccess var0, BlockPosition var1, boolean var2) {
            if (this.charge <= 0) {
                return false;
            }
            if (var2) {
                return true;
            }
            if (var0 instanceof WorldServer) {
                WorldServer var3 = (WorldServer)var0;
                return var3.shouldTickBlocksAt(var1);
            }
            return false;
        }

        public void update(GeneratorAccess var0, BlockPosition var1, RandomSource var2, SculkSpreader var3, boolean var4) {
            if (!this.shouldUpdate(var0, var1, var3.isWorldGeneration)) {
                return;
            }
            if (this.updateDelay > 0) {
                --this.updateDelay;
                return;
            }
            IBlockData var5 = var0.getBlockState(this.pos);
            SculkBehaviour var6 = a.getBlockBehaviour(var5);
            if (var4 && var6.attemptSpreadVein(var0, this.pos, var5, this.facings, var3.isWorldGeneration())) {
                if (var6.canChangeBlockStateOnSpread()) {
                    var5 = var0.getBlockState(this.pos);
                    var6 = a.getBlockBehaviour(var5);
                }
                var0.playSound(null, this.pos, SoundEffects.SCULK_BLOCK_SPREAD, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.charge = var6.attemptUseCharge(this, var0, var1, var2, var3, var4);
            if (this.charge <= 0) {
                var6.onDischarged(var0, var5, this.pos, var2);
                return;
            }
            BlockPosition var7 = a.getValidMovementPos(var0, this.pos, var2);
            if (var7 != null) {
                var6.onDischarged(var0, var5, this.pos, var2);
                this.pos = var7.immutable();
                if (var3.isWorldGeneration() && !this.pos.closerThan(new BaseBlockPosition(var1.getX(), this.pos.getY(), var1.getZ()), 15.0)) {
                    this.charge = 0;
                    return;
                }
                var5 = var0.getBlockState(var7);
            }
            if (var5.getBlock() instanceof SculkBehaviour) {
                this.facings = MultifaceBlock.availableFaces(var5);
            }
            this.decayDelay = var6.updateDecayDelay(this.decayDelay);
            this.updateDelay = var6.getSculkSpreadDelay();
        }

        void mergeWith(a var0) {
            this.charge += var0.charge;
            var0.charge = 0;
            this.updateDelay = Math.min(this.updateDelay, var0.updateDelay);
        }

        private static SculkBehaviour getBlockBehaviour(IBlockData var0) {
            SculkBehaviour var1;
            Block block = var0.getBlock();
            return block instanceof SculkBehaviour ? (var1 = (SculkBehaviour)((Object)block)) : SculkBehaviour.DEFAULT;
        }

        private static List<BaseBlockPosition> getRandomizedNonCornerNeighbourOffsets(RandomSource var0) {
            return SystemUtils.shuffledCopy(NON_CORNER_NEIGHBOURS, var0);
        }

        @Nullable
        private static BlockPosition getValidMovementPos(GeneratorAccess var0, BlockPosition var1, RandomSource var2) {
            BlockPosition.MutableBlockPosition var3 = var1.mutable();
            BlockPosition.MutableBlockPosition var4 = var1.mutable();
            for (BaseBlockPosition var6 : a.getRandomizedNonCornerNeighbourOffsets(var2)) {
                var4.setWithOffset((BaseBlockPosition)var1, var6);
                IBlockData var7 = var0.getBlockState(var4);
                if (!(var7.getBlock() instanceof SculkBehaviour) || !a.isMovementUnobstructed(var0, var1, var4)) continue;
                var3.set(var4);
                if (!SculkVeinBlock.hasSubstrateAccess(var0, var7, var4)) continue;
                break;
            }
            return var3.equals(var1) ? null : var3;
        }

        private static boolean isMovementUnobstructed(GeneratorAccess var0, BlockPosition var1, BlockPosition var2) {
            if (var1.distManhattan(var2) == 1) {
                return true;
            }
            BlockPosition var3 = var2.subtract(var1);
            EnumDirection var4 = EnumDirection.fromAxisAndDirection(EnumDirection.EnumAxis.X, var3.getX() < 0 ? EnumDirection.EnumAxisDirection.NEGATIVE : EnumDirection.EnumAxisDirection.POSITIVE);
            EnumDirection var5 = EnumDirection.fromAxisAndDirection(EnumDirection.EnumAxis.Y, var3.getY() < 0 ? EnumDirection.EnumAxisDirection.NEGATIVE : EnumDirection.EnumAxisDirection.POSITIVE);
            EnumDirection var6 = EnumDirection.fromAxisAndDirection(EnumDirection.EnumAxis.Z, var3.getZ() < 0 ? EnumDirection.EnumAxisDirection.NEGATIVE : EnumDirection.EnumAxisDirection.POSITIVE);
            if (var3.getX() == 0) {
                return a.isUnobstructed(var0, var1, var5) || a.isUnobstructed(var0, var1, var6);
            }
            if (var3.getY() == 0) {
                return a.isUnobstructed(var0, var1, var4) || a.isUnobstructed(var0, var1, var6);
            }
            return a.isUnobstructed(var0, var1, var4) || a.isUnobstructed(var0, var1, var5);
        }

        private static boolean isUnobstructed(GeneratorAccess var0, BlockPosition var1, EnumDirection var2) {
            BlockPosition var3 = var1.relative(var2);
            return !var0.getBlockState(var3).isFaceSturdy(var0, var3, var2.getOpposite());
        }
    }
}

