/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SculkCatalystBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEventListener;

public class SculkCatalystBlock
extends BlockTileEntity {
    public static final int PULSE_TICKS = 8;
    public static final BlockStateBoolean PULSE = BlockProperties.BLOOM;
    private final IntProvider xpRange = ConstantInt.of(20);

    public SculkCatalystBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(PULSE, false));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(PULSE);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var0.getValue(PULSE).booleanValue()) {
            var1.setBlock(var2, (IBlockData)var0.setValue(PULSE, false), 3);
        }
    }

    public static void bloom(WorldServer var0, BlockPosition var1, IBlockData var2, RandomSource var3) {
        var0.setBlock(var1, (IBlockData)var2.setValue(PULSE, true), 3);
        var0.scheduleTick(var1, var2.getBlock(), 8);
        var0.sendParticles(Particles.SCULK_SOUL, (double)var1.getX() + 0.5, (double)var1.getY() + 1.15, (double)var1.getZ() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
        var0.playSound(null, var1, SoundEffects.SCULK_CATALYST_BLOOM, SoundCategory.BLOCKS, 2.0f, 0.6f + var3.nextFloat() * 0.4f);
    }

    @Override
    @Nullable
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new SculkCatalystBlockEntity(var0, var1);
    }

    @Override
    @Nullable
    public <T extends TileEntity> GameEventListener getListener(WorldServer var0, T var1) {
        if (var1 instanceof SculkCatalystBlockEntity) {
            SculkCatalystBlockEntity var2 = (SculkCatalystBlockEntity)var1;
            return var2;
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        if (var0.isClientSide) {
            return null;
        }
        return SculkCatalystBlock.createTickerHelper(var2, TileEntityTypes.SCULK_CATALYST, SculkCatalystBlockEntity::serverTick);
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    public void spawnAfterBreak(IBlockData var0, WorldServer var1, BlockPosition var2, ItemStack var3, boolean var4) {
        super.spawnAfterBreak(var0, var1, var2, var3, var4);
        if (var4) {
            this.tryDropExperience(var1, var2, var3, this.xpRange);
        }
    }
}

