/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapeCollisionEntity;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class PowderSnowBlock
extends Block
implements IFluidSource {
    private static final float HORIZONTAL_PARTICLE_MOMENTUM_FACTOR = 0.083333336f;
    private static final float IN_BLOCK_HORIZONTAL_SPEED_MULTIPLIER = 0.9f;
    private static final float IN_BLOCK_VERTICAL_SPEED_MULTIPLIER = 1.5f;
    private static final float NUM_BLOCKS_TO_FALL_INTO_BLOCK = 2.5f;
    private static final VoxelShape FALLING_COLLISION_SHAPE = VoxelShapes.box(0.0, 0.0, 0.0, 1.0, 0.9f, 1.0);
    private static final double MINIMUM_FALL_DISTANCE_FOR_SOUND = 4.0;
    private static final double MINIMUM_FALL_DISTANCE_FOR_BIG_SOUND = 7.0;

    public PowderSnowBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public boolean skipRendering(IBlockData var0, IBlockData var1, EnumDirection var2) {
        if (var1.is(this)) {
            return true;
        }
        return super.skipRendering(var0, var1, var2);
    }

    @Override
    public VoxelShape getOcclusionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return VoxelShapes.empty();
    }

    @Override
    public void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3) {
        if (!(var3 instanceof EntityLiving) || var3.getFeetBlockState().is(this)) {
            var3.makeStuckInBlock(var0, new Vec3D(0.9f, 1.5, 0.9f));
            if (var1.isClientSide) {
                boolean var5;
                RandomSource var4 = var1.getRandom();
                boolean bl = var5 = var3.xOld != var3.getX() || var3.zOld != var3.getZ();
                if (var5 && var4.nextBoolean()) {
                    var1.addParticle(Particles.SNOWFLAKE, var3.getX(), var2.getY() + 1, var3.getZ(), MathHelper.randomBetween(var4, -1.0f, 1.0f) * 0.083333336f, 0.05f, MathHelper.randomBetween(var4, -1.0f, 1.0f) * 0.083333336f);
                }
            }
        }
        var3.setIsInPowderSnow(true);
        if (!var1.isClientSide) {
            if (var3.isOnFire() && (var1.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) || var3 instanceof EntityHuman) && var3.mayInteract(var1, var2)) {
                var1.destroyBlock(var2, false);
            }
            var3.setSharedFlagOnFire(false);
        }
    }

    @Override
    public void fallOn(World var0, IBlockData var1, BlockPosition var2, Entity var3, float var4) {
        if ((double)var4 < 4.0 || !(var3 instanceof EntityLiving)) {
            return;
        }
        EntityLiving var5 = (EntityLiving)var3;
        EntityLiving.a var6 = var5.getFallSounds();
        SoundEffect var7 = (double)var4 < 7.0 ? var6.small() : var6.big();
        var3.playSound(var7, 1.0f, 1.0f);
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        VoxelShapeCollisionEntity var4;
        Entity var5;
        if (var3 instanceof VoxelShapeCollisionEntity && (var5 = (var4 = (VoxelShapeCollisionEntity)var3).getEntity()) != null) {
            if (var5.fallDistance > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            boolean var6 = var5 instanceof EntityFallingBlock;
            if (var6 || PowderSnowBlock.canEntityWalkOnPowderSnow(var5) && var3.isAbove(VoxelShapes.block(), var2, false) && !var3.isDescending()) {
                return super.getCollisionShape(var0, var1, var2, var3);
            }
        }
        return VoxelShapes.empty();
    }

    @Override
    public VoxelShape getVisualShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return VoxelShapes.empty();
    }

    public static boolean canEntityWalkOnPowderSnow(Entity var0) {
        if (var0.getType().is(TagsEntity.POWDER_SNOW_WALKABLE_MOBS)) {
            return true;
        }
        if (var0 instanceof EntityLiving) {
            return ((EntityLiving)var0).getItemBySlot(EnumItemSlot.FEET).is(Items.LEATHER_BOOTS);
        }
        return false;
    }

    @Override
    public ItemStack pickupBlock(GeneratorAccess var0, BlockPosition var1, IBlockData var2) {
        var0.setBlock(var1, Blocks.AIR.defaultBlockState(), 11);
        if (!var0.isClientSide()) {
            var0.levelEvent(2001, var1, Block.getId(var2));
        }
        return new ItemStack(Items.POWDER_SNOW_BUCKET);
    }

    @Override
    public Optional<SoundEffect> getPickupSound() {
        return Optional.of(SoundEffects.BUCKET_FILL_POWDER_SNOW);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return true;
    }
}

