/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTripwire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockTripwireHook
extends Block {
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateBoolean ATTACHED = BlockProperties.ATTACHED;
    protected static final int WIRE_DIST_MIN = 1;
    protected static final int WIRE_DIST_MAX = 42;
    private static final int RECHECK_PERIOD = 10;
    protected static final int AABB_OFFSET = 3;
    protected static final VoxelShape NORTH_AABB = Block.box(5.0, 0.0, 10.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box(5.0, 0.0, 0.0, 11.0, 10.0, 6.0);
    protected static final VoxelShape WEST_AABB = Block.box(10.0, 0.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 0.0, 5.0, 6.0, 10.0, 11.0);

    public BlockTripwireHook(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(POWERED, false)).setValue(ATTACHED, false));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        switch (var0.getValue(FACING)) {
            default: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: 
        }
        return NORTH_AABB;
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        EnumDirection var3 = var0.getValue(FACING);
        BlockPosition var4 = var2.relative(var3.getOpposite());
        IBlockData var5 = var1.getBlockState(var4);
        return var3.getAxis().isHorizontal() && var5.isFaceSturdy(var1, var4, var3);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1.getOpposite() == var0.getValue(FACING) && !var0.canSurvive(var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection[] var4;
        IBlockData var1 = (IBlockData)((IBlockData)this.defaultBlockState().setValue(POWERED, false)).setValue(ATTACHED, false);
        World var2 = var0.getLevel();
        BlockPosition var3 = var0.getClickedPos();
        for (EnumDirection var8 : var4 = var0.getNearestLookingDirections()) {
            EnumDirection var9;
            if (!var8.getAxis().isHorizontal() || !(var1 = (IBlockData)var1.setValue(FACING, var9 = var8.getOpposite())).canSurvive(var2, var3)) continue;
            return var1;
        }
        return null;
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, EntityLiving var3, ItemStack var4) {
        this.calculateState(var0, var1, var2, false, false, -1, null);
    }

    public void calculateState(World var0, BlockPosition var1, IBlockData var2, boolean var3, boolean var4, int var5, @Nullable IBlockData var6) {
        Object var16;
        BlockPosition var15;
        EnumDirection var7 = var2.getValue(FACING);
        boolean var8 = var2.getValue(ATTACHED);
        boolean var9 = var2.getValue(POWERED);
        boolean var10 = !var3;
        boolean var11 = false;
        int var12 = 0;
        IBlockData[] var13 = new IBlockData[42];
        for (int var14 = 1; var14 < 42; ++var14) {
            var15 = var1.relative(var7, var14);
            var16 = var0.getBlockState(var15);
            if (((BlockBase.BlockData)var16).is(Blocks.TRIPWIRE_HOOK)) {
                if (((IBlockDataHolder)var16).getValue(FACING) != var7.getOpposite()) break;
                var12 = var14;
                break;
            }
            if (((BlockBase.BlockData)var16).is(Blocks.TRIPWIRE) || var14 == var5) {
                if (var14 == var5) {
                    var16 = (IBlockData)MoreObjects.firstNonNull((Object)var6, (Object)var16);
                }
                boolean var17 = ((IBlockDataHolder)var16).getValue(BlockTripwire.DISARMED) == false;
                boolean var18 = ((IBlockDataHolder)var16).getValue(BlockTripwire.POWERED);
                var11 |= var17 && var18;
                var13[var14] = var16;
                if (var14 != var5) continue;
                var0.scheduleTick(var1, this, 10);
                var10 &= var17;
                continue;
            }
            var13[var14] = null;
            var10 = false;
        }
        IBlockData var14 = (IBlockData)((IBlockData)this.defaultBlockState().setValue(ATTACHED, var10)).setValue(POWERED, var11 &= (var10 &= var12 > 1));
        if (var12 > 0) {
            var15 = var1.relative(var7, var12);
            var16 = var7.getOpposite();
            var0.setBlock(var15, (IBlockData)var14.setValue(FACING, var16), 3);
            this.notifyNeighbors(var0, var15, (EnumDirection)var16);
            this.emitState(var0, var15, var10, var11, var8, var9);
        }
        this.emitState(var0, var1, var10, var11, var8, var9);
        if (!var3) {
            var0.setBlock(var1, (IBlockData)var14.setValue(FACING, var7), 3);
            if (var4) {
                this.notifyNeighbors(var0, var1, var7);
            }
        }
        if (var8 != var10) {
            for (int var152 = 1; var152 < var12; ++var152) {
                var16 = var1.relative(var7, var152);
                IBlockData var17 = var13[var152];
                if (var17 == null) continue;
                var0.setBlock((BlockPosition)var16, (IBlockData)var17.setValue(ATTACHED, var10), 3);
                if (var0.getBlockState((BlockPosition)var16).isAir()) continue;
            }
        }
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        this.calculateState(var1, var2, var0, false, true, -1, null);
    }

    private void emitState(World var0, BlockPosition var1, boolean var2, boolean var3, boolean var4, boolean var5) {
        if (var3 && !var5) {
            var0.playSound(null, var1, SoundEffects.TRIPWIRE_CLICK_ON, SoundCategory.BLOCKS, 0.4f, 0.6f);
            var0.gameEvent(null, GameEvent.BLOCK_ACTIVATE, var1);
        } else if (!var3 && var5) {
            var0.playSound(null, var1, SoundEffects.TRIPWIRE_CLICK_OFF, SoundCategory.BLOCKS, 0.4f, 0.5f);
            var0.gameEvent(null, GameEvent.BLOCK_DEACTIVATE, var1);
        } else if (var2 && !var4) {
            var0.playSound(null, var1, SoundEffects.TRIPWIRE_ATTACH, SoundCategory.BLOCKS, 0.4f, 0.7f);
            var0.gameEvent(null, GameEvent.BLOCK_ATTACH, var1);
        } else if (!var2 && var4) {
            var0.playSound(null, var1, SoundEffects.TRIPWIRE_DETACH, SoundCategory.BLOCKS, 0.4f, 1.2f / (var0.random.nextFloat() * 0.2f + 0.9f));
            var0.gameEvent(null, GameEvent.BLOCK_DETACH, var1);
        }
    }

    private void notifyNeighbors(World var0, BlockPosition var1, EnumDirection var2) {
        var0.updateNeighborsAt(var1, this);
        var0.updateNeighborsAt(var1.relative(var2.getOpposite()), this);
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var4 || var0.is(var3.getBlock())) {
            return;
        }
        boolean var5 = var0.getValue(ATTACHED);
        boolean var6 = var0.getValue(POWERED);
        if (var5 || var6) {
            this.calculateState(var1, var2, var0, true, false, -1, null);
        }
        if (var6) {
            var1.updateNeighborsAt(var2, this);
            var1.updateNeighborsAt(var2.relative(var0.getValue(FACING).getOpposite()), this);
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    public int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (!var0.getValue(POWERED).booleanValue()) {
            return 0;
        }
        if (var0.getValue(FACING) == var3) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, POWERED, ATTACHED);
    }
}

