/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityComparator;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyComparatorMode;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.ticks.TickListPriority;

public class BlockRedstoneComparator
extends BlockDiodeAbstract
implements ITileEntity {
    public static final BlockStateEnum<BlockPropertyComparatorMode> MODE = BlockProperties.MODE_COMPARATOR;

    public BlockRedstoneComparator(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(POWERED, false)).setValue(MODE, BlockPropertyComparatorMode.COMPARE));
    }

    @Override
    protected int getDelay(IBlockData var0) {
        return 2;
    }

    @Override
    protected int getOutputSignal(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        TileEntity var3 = var0.getBlockEntity(var1);
        if (var3 instanceof TileEntityComparator) {
            return ((TileEntityComparator)var3).getOutputSignal();
        }
        return 0;
    }

    private int calculateOutputSignal(World var0, BlockPosition var1, IBlockData var2) {
        int var3 = this.getInputSignal(var0, var1, var2);
        if (var3 == 0) {
            return 0;
        }
        int var4 = this.getAlternateSignal(var0, var1, var2);
        if (var4 > var3) {
            return 0;
        }
        if (var2.getValue(MODE) == BlockPropertyComparatorMode.SUBTRACT) {
            return var3 - var4;
        }
        return var3;
    }

    @Override
    protected boolean shouldTurnOn(World var0, BlockPosition var1, IBlockData var2) {
        int var3 = this.getInputSignal(var0, var1, var2);
        if (var3 == 0) {
            return false;
        }
        int var4 = this.getAlternateSignal(var0, var1, var2);
        if (var3 > var4) {
            return true;
        }
        return var3 == var4 && var2.getValue(MODE) == BlockPropertyComparatorMode.COMPARE;
    }

    @Override
    protected int getInputSignal(World var0, BlockPosition var1, IBlockData var2) {
        int var3 = super.getInputSignal(var0, var1, var2);
        EnumDirection var4 = var2.getValue(FACING);
        BlockPosition var5 = var1.relative(var4);
        IBlockData var6 = var0.getBlockState(var5);
        if (var6.hasAnalogOutputSignal()) {
            var3 = var6.getAnalogOutputSignal(var0, var5);
        } else if (var3 < 15 && var6.isRedstoneConductor(var0, var5)) {
            var5 = var5.relative(var4);
            var6 = var0.getBlockState(var5);
            EntityItemFrame var7 = this.getItemFrame(var0, var4, var5);
            int var8 = Math.max(var7 == null ? Integer.MIN_VALUE : var7.getAnalogOutput(), var6.hasAnalogOutputSignal() ? var6.getAnalogOutputSignal(var0, var5) : Integer.MIN_VALUE);
            if (var8 != Integer.MIN_VALUE) {
                var3 = var8;
            }
        }
        return var3;
    }

    @Nullable
    private EntityItemFrame getItemFrame(World var0, EnumDirection var12, BlockPosition var2) {
        List<EntityItemFrame> var3 = var0.getEntitiesOfClass(EntityItemFrame.class, new AxisAlignedBB(var2.getX(), var2.getY(), var2.getZ(), var2.getX() + 1, var2.getY() + 1, var2.getZ() + 1), var1 -> var1 != null && var1.getDirection() == var12);
        if (var3.size() == 1) {
            return var3.get(0);
        }
        return null;
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (!var3.getAbilities().mayBuild) {
            return EnumInteractionResult.PASS;
        }
        float var6 = (var0 = (IBlockData)var0.cycle(MODE)).getValue(MODE) == BlockPropertyComparatorMode.SUBTRACT ? 0.55f : 0.5f;
        var1.playSound(var3, var2, SoundEffects.COMPARATOR_CLICK, SoundCategory.BLOCKS, 0.3f, var6);
        var1.setBlock(var2, var0, 2);
        this.refreshOutputState(var1, var2, var0);
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }

    @Override
    protected void checkTickOnNeighbor(World var0, BlockPosition var1, IBlockData var2) {
        int var5;
        if (var0.getBlockTicks().willTickThisTick(var1, this)) {
            return;
        }
        int var3 = this.calculateOutputSignal(var0, var1, var2);
        TileEntity var4 = var0.getBlockEntity(var1);
        int n2 = var5 = var4 instanceof TileEntityComparator ? ((TileEntityComparator)var4).getOutputSignal() : 0;
        if (var3 != var5 || var2.getValue(POWERED).booleanValue() != this.shouldTurnOn(var0, var1, var2)) {
            TickListPriority var6 = this.shouldPrioritize(var0, var1, var2) ? TickListPriority.HIGH : TickListPriority.NORMAL;
            var0.scheduleTick(var1, this, 2, var6);
        }
    }

    private void refreshOutputState(World var0, BlockPosition var1, IBlockData var2) {
        int var3 = this.calculateOutputSignal(var0, var1, var2);
        TileEntity var4 = var0.getBlockEntity(var1);
        int var5 = 0;
        if (var4 instanceof TileEntityComparator) {
            TileEntityComparator var6 = (TileEntityComparator)var4;
            var5 = var6.getOutputSignal();
            var6.setOutputSignal(var3);
        }
        if (var5 != var3 || var2.getValue(MODE) == BlockPropertyComparatorMode.COMPARE) {
            boolean var6 = this.shouldTurnOn(var0, var1, var2);
            boolean var7 = var2.getValue(POWERED);
            if (var7 && !var6) {
                var0.setBlock(var1, (IBlockData)var2.setValue(POWERED, false), 2);
            } else if (!var7 && var6) {
                var0.setBlock(var1, (IBlockData)var2.setValue(POWERED, true), 2);
            }
            this.updateNeighborsInFront(var0, var1, var2);
        }
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        this.refreshOutputState(var1, var2, var0);
    }

    @Override
    public boolean triggerEvent(IBlockData var0, World var1, BlockPosition var2, int var3, int var4) {
        super.triggerEvent(var0, var1, var2, var3, var4);
        TileEntity var5 = var1.getBlockEntity(var2);
        return var5 != null && var5.triggerEvent(var3, var4);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityComparator(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, MODE, POWERED);
    }
}

