/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.lighting.LightEngineLayer;

public class BlockNylium
extends Block
implements IBlockFragilePlantElement {
    protected BlockNylium(BlockBase.Info var0) {
        super(var0);
    }

    private static boolean canBeNylium(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.above();
        IBlockData var4 = var1.getBlockState(var3);
        int var5 = LightEngineLayer.getLightBlockInto(var1, var0, var2, var4, var3, EnumDirection.UP, var4.getLightBlock(var1, var3));
        return var5 < var1.getMaxLightLevel();
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!BlockNylium.canBeNylium(var0, var1, var2)) {
            var1.setBlockAndUpdate(var2, Blocks.NETHERRACK.defaultBlockState());
        }
    }

    @Override
    public boolean isValidBonemealTarget(IBlockAccess var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return var0.getBlockState(var1.above()).isAir();
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        IBlockData var4 = var0.getBlockState(var2);
        BlockPosition var5 = var2.above();
        ChunkGenerator var6 = var0.getChunkSource().getGenerator();
        if (var4.is(Blocks.CRIMSON_NYLIUM)) {
            NetherFeatures.CRIMSON_FOREST_VEGETATION_BONEMEAL.value().place(var0, var6, var1, var5);
        } else if (var4.is(Blocks.WARPED_NYLIUM)) {
            NetherFeatures.WARPED_FOREST_VEGETATION_BONEMEAL.value().place(var0, var6, var1, var5);
            NetherFeatures.NETHER_SPROUTS_BONEMEAL.value().place(var0, var6, var1, var5);
            if (var1.nextInt(8) == 0) {
                NetherFeatures.TWISTING_VINES_BONEMEAL.value().place(var0, var6, var1, var5);
            }
        }
    }
}

