/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemRecord;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockJukeBox
extends BlockTileEntity {
    public static final BlockStateBoolean HAS_RECORD = BlockProperties.HAS_RECORD;

    protected BlockJukeBox(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(HAS_RECORD, false));
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        super.setPlacedBy(var0, var1, var2, var3, var4);
        NBTTagCompound var5 = ItemBlock.getBlockEntityData(var4);
        if (var5 != null && var5.contains("RecordItem")) {
            var0.setBlock(var1, (IBlockData)var2.setValue(HAS_RECORD, true), 2);
        }
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (var0.getValue(HAS_RECORD).booleanValue()) {
            this.dropRecording(var1, var2);
            var0 = (IBlockData)var0.setValue(HAS_RECORD, false);
            var1.setBlock(var2, var0, 2);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var3, var0));
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    public void setRecord(@Nullable Entity var0, GeneratorAccess var1, BlockPosition var2, IBlockData var3, ItemStack var4) {
        TileEntity var5 = var1.getBlockEntity(var2);
        if (!(var5 instanceof TileEntityJukeBox)) {
            return;
        }
        ((TileEntityJukeBox)var5).setRecord(var4.copy());
        var1.setBlock(var2, (IBlockData)var3.setValue(HAS_RECORD, true), 2);
        var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var0, var3));
    }

    public void dropRecording(World var0, BlockPosition var1) {
        if (var0.isClientSide) {
            return;
        }
        TileEntity var2 = var0.getBlockEntity(var1);
        if (!(var2 instanceof TileEntityJukeBox)) {
            return;
        }
        TileEntityJukeBox var3 = (TileEntityJukeBox)var2;
        ItemStack var4 = var3.getRecord();
        if (var4.isEmpty()) {
            return;
        }
        var0.levelEvent(1010, var1, 0);
        var3.clearContent();
        float var5 = 0.7f;
        double var6 = (double)(var0.random.nextFloat() * 0.7f) + (double)0.15f;
        double var8 = (double)(var0.random.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
        double var10 = (double)(var0.random.nextFloat() * 0.7f) + (double)0.15f;
        ItemStack var12 = var4.copy();
        EntityItem var13 = new EntityItem(var0, (double)var1.getX() + var6, (double)var1.getY() + var8, (double)var1.getZ() + var10, var12);
        var13.setDefaultPickUpDelay();
        var0.addFreshEntity(var13);
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        this.dropRecording(var1, var2);
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityJukeBox(var0, var1);
    }

    @Override
    public boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        Item var4;
        TileEntity var3 = var1.getBlockEntity(var2);
        if (var3 instanceof TileEntityJukeBox && (var4 = ((TileEntityJukeBox)var3).getRecord().getItem()) instanceof ItemRecord) {
            return ((ItemRecord)var4).getAnalogOutput();
        }
        return 0;
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(HAS_RECORD);
    }
}

