/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingAbstract;
import net.minecraft.world.level.block.BlockGrowingTop;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BlockGrowingStem
extends BlockGrowingAbstract
implements IBlockFragilePlantElement {
    protected BlockGrowingStem(BlockBase.Info var0, EnumDirection var1, VoxelShape var2, boolean var3) {
        super(var0, var1, var2, var3);
    }

    protected IBlockData updateHeadAfterConvertedFromBody(IBlockData var0, IBlockData var1) {
        return var1;
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == this.growthDirection.getOpposite() && !var0.canSurvive(var3, var4)) {
            var3.scheduleTick(var4, this, 1);
        }
        BlockGrowingTop var6 = this.getHeadBlock();
        if (var1 == this.growthDirection && !var2.is(this) && !var2.is(var6)) {
            return this.updateHeadAfterConvertedFromBody(var0, var6.getStateForPlacement(var3));
        }
        if (this.scheduleFluidTicks) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public ItemStack getCloneItemStack(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        return new ItemStack(this.getHeadBlock());
    }

    @Override
    public boolean isValidBonemealTarget(IBlockAccess var0, BlockPosition var1, IBlockData var2, boolean var3) {
        Optional<BlockPosition> var4 = this.getHeadPos(var0, var1, var2.getBlock());
        return var4.isPresent() && this.getHeadBlock().canGrowInto(var0.getBlockState(var4.get().relative(this.growthDirection)));
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        Optional<BlockPosition> var4 = this.getHeadPos(var0, var2, var3.getBlock());
        if (var4.isPresent()) {
            IBlockData var5 = var0.getBlockState(var4.get());
            ((BlockGrowingTop)var5.getBlock()).performBonemeal(var0, var1, var4.get(), var5);
        }
    }

    private Optional<BlockPosition> getHeadPos(IBlockAccess var0, BlockPosition var1, Block var2) {
        return BlockUtil.getTopConnectedBlock(var0, var1, var2, this.growthDirection, this.getHeadBlock());
    }

    @Override
    public boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        boolean var2 = super.canBeReplaced(var0, var1);
        if (var2 && var1.getItemInHand().is(this.getHeadBlock().asItem())) {
            return false;
        }
        return var2;
    }

    @Override
    protected Block getBodyBlock() {
        return this;
    }
}

