/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureHugeFungiConfiguration;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockFungi
extends BlockPlant
implements IBlockFragilePlantElement {
    protected static final VoxelShape SHAPE = Block.box(4.0, 0.0, 4.0, 12.0, 9.0, 12.0);
    private static final double BONEMEAL_SUCCESS_PROBABILITY = 0.4;
    private final Supplier<Holder<WorldGenFeatureConfigured<WorldGenFeatureHugeFungiConfiguration, ?>>> feature;

    protected BlockFungi(BlockBase.Info var0, Supplier<Holder<WorldGenFeatureConfigured<WorldGenFeatureHugeFungiConfiguration, ?>>> var1) {
        super(var0);
        this.feature = var1;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.is(TagsBlock.NYLIUM) || var0.is(Blocks.MYCELIUM) || var0.is(Blocks.SOUL_SOIL) || super.mayPlaceOn(var0, var1, var2);
    }

    @Override
    public boolean isValidBonemealTarget(IBlockAccess var0, BlockPosition var1, IBlockData var2, boolean var3) {
        Block var4 = this.feature.get().value().config().validBaseState.getBlock();
        IBlockData var5 = var0.getBlockState(var1.below());
        return var5.is(var4);
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return (double)var1.nextFloat() < 0.4;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        this.feature.get().value().place(var0, var0.getChunkSource().getGenerator(), var1, var2);
    }
}

