/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoorHinge;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockDoor
extends Block {
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateBoolean OPEN = BlockProperties.OPEN;
    public static final BlockStateEnum<BlockPropertyDoorHinge> HINGE = BlockProperties.DOOR_HINGE;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateEnum<BlockPropertyDoubleBlockHalf> HALF = BlockProperties.DOUBLE_BLOCK_HALF;
    protected static final float AABB_DOOR_THICKNESS = 3.0f;
    protected static final VoxelShape SOUTH_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 3.0);
    protected static final VoxelShape NORTH_AABB = Block.box(0.0, 0.0, 13.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape WEST_AABB = Block.box(13.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape EAST_AABB = Block.box(0.0, 0.0, 0.0, 3.0, 16.0, 16.0);

    protected BlockDoor(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(OPEN, false)).setValue(HINGE, BlockPropertyDoorHinge.LEFT)).setValue(POWERED, false)).setValue(HALF, BlockPropertyDoubleBlockHalf.LOWER));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        EnumDirection var4 = var0.getValue(FACING);
        boolean var5 = var0.getValue(OPEN) == false;
        boolean var6 = var0.getValue(HINGE) == BlockPropertyDoorHinge.RIGHT;
        switch (var4) {
            default: {
                return var5 ? EAST_AABB : (var6 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return var5 ? SOUTH_AABB : (var6 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return var5 ? WEST_AABB : (var6 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return var5 ? NORTH_AABB : (var6 ? WEST_AABB : EAST_AABB);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        BlockPropertyDoubleBlockHalf var6 = var0.getValue(HALF);
        if (var1.getAxis() == EnumDirection.EnumAxis.Y && var6 == BlockPropertyDoubleBlockHalf.LOWER == (var1 == EnumDirection.UP)) {
            if (var2.is(this) && var2.getValue(HALF) != var6) {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(FACING, var2.getValue(FACING))).setValue(OPEN, var2.getValue(OPEN))).setValue(HINGE, var2.getValue(HINGE))).setValue(POWERED, var2.getValue(POWERED));
            }
            return Blocks.AIR.defaultBlockState();
        }
        if (var6 == BlockPropertyDoubleBlockHalf.LOWER && var1 == EnumDirection.DOWN && !var0.canSurvive(var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public void playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        if (!var0.isClientSide && var3.isCreative()) {
            BlockTallPlant.preventCreativeDropFromBottomPart(var0, var1, var2, var3);
        }
        super.playerWillDestroy(var0, var1, var2, var3);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        switch (var3) {
            case LAND: {
                return var0.getValue(OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return var0.getValue(OPEN);
            }
        }
        return false;
    }

    private int getCloseSound() {
        return this.material == Material.METAL ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.material == Material.METAL ? 1005 : 1006;
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        BlockPosition var1 = var0.getClickedPos();
        World var2 = var0.getLevel();
        if (var1.getY() < var2.getMaxBuildHeight() - 1 && var2.getBlockState(var1.above()).canBeReplaced(var0)) {
            boolean var3 = var2.hasNeighborSignal(var1) || var2.hasNeighborSignal(var1.above());
            return (IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection())).setValue(HINGE, this.getHinge(var0))).setValue(POWERED, var3)).setValue(OPEN, var3)).setValue(HALF, BlockPropertyDoubleBlockHalf.LOWER);
        }
        return null;
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, EntityLiving var3, ItemStack var4) {
        var0.setBlock(var1.above(), (IBlockData)var2.setValue(HALF, BlockPropertyDoubleBlockHalf.UPPER), 3);
    }

    private BlockPropertyDoorHinge getHinge(BlockActionContext var0) {
        boolean var17;
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        EnumDirection var3 = var0.getHorizontalDirection();
        BlockPosition var4 = var2.above();
        EnumDirection var5 = var3.getCounterClockWise();
        BlockPosition var6 = var2.relative(var5);
        IBlockData var7 = var1.getBlockState(var6);
        BlockPosition var8 = var4.relative(var5);
        IBlockData var9 = var1.getBlockState(var8);
        EnumDirection var10 = var3.getClockWise();
        BlockPosition var11 = var2.relative(var10);
        IBlockData var12 = var1.getBlockState(var11);
        BlockPosition var13 = var4.relative(var10);
        IBlockData var14 = var1.getBlockState(var13);
        int var15 = (var7.isCollisionShapeFullBlock(var1, var6) ? -1 : 0) + (var9.isCollisionShapeFullBlock(var1, var8) ? -1 : 0) + (var12.isCollisionShapeFullBlock(var1, var11) ? 1 : 0) + (var14.isCollisionShapeFullBlock(var1, var13) ? 1 : 0);
        boolean var16 = var7.is(this) && var7.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER;
        boolean bl = var17 = var12.is(this) && var12.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER;
        if (var16 && !var17 || var15 > 0) {
            return BlockPropertyDoorHinge.RIGHT;
        }
        if (var17 && !var16 || var15 < 0) {
            return BlockPropertyDoorHinge.LEFT;
        }
        int var18 = var3.getStepX();
        int var19 = var3.getStepZ();
        Vec3D var20 = var0.getClickLocation();
        double var21 = var20.x - (double)var2.getX();
        double var23 = var20.z - (double)var2.getZ();
        return var18 < 0 && var23 < 0.5 || var18 > 0 && var23 > 0.5 || var19 < 0 && var21 > 0.5 || var19 > 0 && var21 < 0.5 ? BlockPropertyDoorHinge.RIGHT : BlockPropertyDoorHinge.LEFT;
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (this.material == Material.METAL) {
            return EnumInteractionResult.PASS;
        }
        var0 = (IBlockData)var0.cycle(OPEN);
        var1.setBlock(var2, var0, 10);
        var1.levelEvent(var3, var0.getValue(OPEN) != false ? this.getOpenSound() : this.getCloseSound(), var2, 0);
        var1.gameEvent((Entity)var3, this.isOpen(var0) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, var2);
        return EnumInteractionResult.sidedSuccess(var1.isClientSide);
    }

    public boolean isOpen(IBlockData var0) {
        return var0.getValue(OPEN);
    }

    public void setOpen(@Nullable Entity var0, World var1, IBlockData var2, BlockPosition var3, boolean var4) {
        if (!var2.is(this) || var2.getValue(OPEN) == var4) {
            return;
        }
        var1.setBlock(var3, (IBlockData)var2.setValue(OPEN, var4), 10);
        this.playSound(var1, var3, var4);
        var1.gameEvent(var0, var4 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, var3);
    }

    @Override
    public void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, BlockPosition var4, boolean var5) {
        boolean var6;
        boolean bl = var1.hasNeighborSignal(var2) || var1.hasNeighborSignal(var2.relative(var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER ? EnumDirection.UP : EnumDirection.DOWN)) ? true : (var6 = false);
        if (!this.defaultBlockState().is(var3) && var6 != var0.getValue(POWERED)) {
            if (var6 != var0.getValue(OPEN)) {
                this.playSound(var1, var2, var6);
                var1.gameEvent(null, var6 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, var2);
            }
            var1.setBlock(var2, (IBlockData)((IBlockData)var0.setValue(POWERED, var6)).setValue(OPEN, var6), 2);
        }
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.below();
        IBlockData var4 = var1.getBlockState(var3);
        if (var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER) {
            return var4.isFaceSturdy(var1, var3, EnumDirection.UP);
        }
        return var4.is(this);
    }

    private void playSound(World var0, BlockPosition var1, boolean var2) {
        var0.levelEvent(null, var2 ? this.getOpenSound() : this.getCloseSound(), var1, 0);
    }

    @Override
    public EnumPistonReaction getPistonPushReaction(IBlockData var0) {
        return EnumPistonReaction.DESTROY;
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        if (var1 == EnumBlockMirror.NONE) {
            return var0;
        }
        return (IBlockData)var0.rotate(var1.getRotation(var0.getValue(FACING))).cycle(HINGE);
    }

    @Override
    public long getSeed(IBlockData var0, BlockPosition var1) {
        return MathHelper.getSeed(var1.getX(), var1.below(var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER ? 0 : 1).getY(), var1.getZ());
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(HALF, FACING, OPEN, HINGE, POWERED);
    }

    public static boolean isWoodenDoor(World var0, BlockPosition var1) {
        return BlockDoor.isWoodenDoor(var0.getBlockState(var1));
    }

    public static boolean isWoodenDoor(IBlockData var0) {
        return var0.getBlock() instanceof BlockDoor && (var0.getMaterial() == Material.WOOD || var0.getMaterial() == Material.NETHER_WOOD);
    }
}

