/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.INamable;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;

public class BiomeSettingsGeneration {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BiomeSettingsGeneration EMPTY = new BiomeSettingsGeneration((Map<WorldGenStage.Features, HolderSet<WorldGenCarverWrapper<?>>>)ImmutableMap.of(), (List<HolderSet<PlacedFeature>>)ImmutableList.of());
    public static final MapCodec<BiomeSettingsGeneration> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.simpleMap(WorldGenStage.Features.CODEC, (Codec)WorldGenCarverWrapper.LIST_CODEC.promotePartial(SystemUtils.prefix("Carver: ", arg_0 -> ((Logger)LOGGER).error(arg_0))), (Keyable)INamable.keys(WorldGenStage.Features.values())).fieldOf("carvers").forGetter(var0 -> var0.carvers), (App)PlacedFeature.LIST_OF_LISTS_CODEC.promotePartial(SystemUtils.prefix("Features: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).fieldOf("features").forGetter(var0 -> var0.features)).apply((Applicative)var02, BiomeSettingsGeneration::new));
    private final Map<WorldGenStage.Features, HolderSet<WorldGenCarverWrapper<?>>> carvers;
    private final List<HolderSet<PlacedFeature>> features;
    private final Supplier<List<WorldGenFeatureConfigured<?, ?>>> flowerFeatures;
    private final Supplier<Set<PlacedFeature>> featureSet;

    BiomeSettingsGeneration(Map<WorldGenStage.Features, HolderSet<WorldGenCarverWrapper<?>>> var0, List<HolderSet<PlacedFeature>> var1) {
        this.carvers = var0;
        this.features = var1;
        this.flowerFeatures = Suppliers.memoize(() -> (List)var1.stream().flatMap(HolderSet::stream).map(Holder::value).flatMap(PlacedFeature::getFeatures).filter(var0 -> var0.feature() == WorldGenerator.FLOWER).collect(ImmutableList.toImmutableList()));
        this.featureSet = Suppliers.memoize(() -> var1.stream().flatMap(HolderSet::stream).map(Holder::value).collect(Collectors.toSet()));
    }

    public Iterable<Holder<WorldGenCarverWrapper<?>>> getCarvers(WorldGenStage.Features var0) {
        return Objects.requireNonNullElseGet((Iterable)this.carvers.get(var0), List::of);
    }

    public List<WorldGenFeatureConfigured<?, ?>> getFlowerFeatures() {
        return this.flowerFeatures.get();
    }

    public List<HolderSet<PlacedFeature>> features() {
        return this.features;
    }

    public boolean hasFeature(PlacedFeature var0) {
        return this.featureSet.get().contains(var0);
    }

    public static class a {
        private final Map<WorldGenStage.Features, List<Holder<WorldGenCarverWrapper<?>>>> carvers = Maps.newLinkedHashMap();
        private final List<List<Holder<PlacedFeature>>> features = Lists.newArrayList();

        public a addFeature(WorldGenStage.Decoration var0, Holder<PlacedFeature> var1) {
            return this.addFeature(var0.ordinal(), var1);
        }

        public a addFeature(int var0, Holder<PlacedFeature> var1) {
            this.addFeatureStepsUpTo(var0);
            this.features.get(var0).add(var1);
            return this;
        }

        public a addCarver(WorldGenStage.Features var02, Holder<? extends WorldGenCarverWrapper<?>> var1) {
            this.carvers.computeIfAbsent(var02, var0 -> Lists.newArrayList()).add(Holder.hackyErase(var1));
            return this;
        }

        private void addFeatureStepsUpTo(int var0) {
            while (this.features.size() <= var0) {
                this.features.add(Lists.newArrayList());
            }
        }

        public BiomeSettingsGeneration build() {
            return new BiomeSettingsGeneration((Map)this.carvers.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, var0 -> HolderSet.direct((List)var0.getValue()))), (List)this.features.stream().map(HolderSet::direct).collect(ImmutableList.toImmutableList()));
        }
    }
}

