/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemHanging
extends Item {
    private final EntityTypes<? extends EntityHanging> type;

    public ItemHanging(EntityTypes<? extends EntityHanging> var0, Item.Info var1) {
        super(var1);
        this.type = var0;
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        EntityHanging var7;
        Optional<EntityPainting> var8;
        BlockPosition var1 = var0.getClickedPos();
        EnumDirection var2 = var0.getClickedFace();
        BlockPosition var3 = var1.relative(var2);
        EntityHuman var4 = var0.getPlayer();
        ItemStack var5 = var0.getItemInHand();
        if (var4 != null && !this.mayPlace(var4, var2, var5, var3)) {
            return EnumInteractionResult.FAIL;
        }
        World var6 = var0.getLevel();
        if (this.type == EntityTypes.PAINTING) {
            var8 = EntityPainting.create(var6, var3, var2);
            if (var8.isEmpty()) {
                return EnumInteractionResult.CONSUME;
            }
            var7 = var8.get();
        } else if (this.type == EntityTypes.ITEM_FRAME) {
            var7 = new EntityItemFrame(var6, var3, var2);
        } else if (this.type == EntityTypes.GLOW_ITEM_FRAME) {
            var7 = new GlowItemFrame(var6, var3, var2);
        } else {
            return EnumInteractionResult.sidedSuccess(var6.isClientSide);
        }
        var8 = var5.getTag();
        if (var8 != null) {
            EntityTypes.updateCustomEntityTag(var6, var4, var7, (NBTTagCompound)((Object)var8));
        }
        if (var7.survives()) {
            if (!var6.isClientSide) {
                var7.playPlacementSound();
                var6.gameEvent((Entity)var4, GameEvent.ENTITY_PLACE, var7.position());
                var6.addFreshEntity(var7);
            }
            var5.shrink(1);
            return EnumInteractionResult.sidedSuccess(var6.isClientSide);
        }
        return EnumInteractionResult.CONSUME;
    }

    protected boolean mayPlace(EntityHuman var0, EnumDirection var1, ItemStack var2, BlockPosition var3) {
        return !var1.getAxis().isVertical() && var0.mayUseItemAt(var3, var1, var2);
    }
}

