/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.level.World;

public class ItemEnchantedBook
extends Item {
    public static final String TAG_STORED_ENCHANTMENTS = "StoredEnchantments";

    public ItemEnchantedBook(Item.Info var0) {
        super(var0);
    }

    @Override
    public boolean isFoil(ItemStack var0) {
        return true;
    }

    @Override
    public boolean isEnchantable(ItemStack var0) {
        return false;
    }

    public static NBTTagList getEnchantments(ItemStack var0) {
        NBTTagCompound var1 = var0.getTag();
        if (var1 != null) {
            return var1.getList(TAG_STORED_ENCHANTMENTS, 10);
        }
        return new NBTTagList();
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        ItemStack.appendEnchantmentNames(var2, ItemEnchantedBook.getEnchantments(var0));
    }

    public static void addEnchantment(ItemStack var0, WeightedRandomEnchant var1) {
        NBTTagList var2 = ItemEnchantedBook.getEnchantments(var0);
        boolean var3 = true;
        MinecraftKey var4 = EnchantmentManager.getEnchantmentId(var1.enchantment);
        for (int var5 = 0; var5 < var2.size(); ++var5) {
            NBTTagCompound var6 = var2.getCompound(var5);
            MinecraftKey var7 = EnchantmentManager.getEnchantmentId(var6);
            if (var7 == null || !var7.equals(var4)) continue;
            if (EnchantmentManager.getEnchantmentLevel(var6) < var1.level) {
                EnchantmentManager.setEnchantmentLevel(var6, var1.level);
            }
            var3 = false;
            break;
        }
        if (var3) {
            var2.add(EnchantmentManager.storeEnchantment(var4, var1.level));
        }
        var0.getOrCreateTag().put(TAG_STORED_ENCHANTMENTS, var2);
    }

    public static ItemStack createForEnchantment(WeightedRandomEnchant var0) {
        ItemStack var1 = new ItemStack(Items.ENCHANTED_BOOK);
        ItemEnchantedBook.addEnchantment(var1, var0);
        return var1;
    }

    @Override
    public void fillItemCategory(CreativeModeTab var0, NonNullList<ItemStack> var1) {
        block4: {
            block3: {
                if (var0 != CreativeModeTab.TAB_SEARCH) break block3;
                for (Enchantment var3 : IRegistry.ENCHANTMENT) {
                    if (var3.category == null) continue;
                    for (int var4 = var3.getMinLevel(); var4 <= var3.getMaxLevel(); ++var4) {
                        var1.add(ItemEnchantedBook.createForEnchantment(new WeightedRandomEnchant(var3, var4)));
                    }
                }
                break block4;
            }
            if (var0.getEnchantmentCategories().length == 0) break block4;
            for (Enchantment var3 : IRegistry.ENCHANTMENT) {
                if (!var0.hasEnchantmentCategory(var3.category)) continue;
                var1.add(ItemEnchantedBook.createForEnchantment(new WeightedRandomEnchant(var3, var3.getMaxLevel())));
            }
        }
    }
}

