/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class ItemDebugStick
extends Item {
    public ItemDebugStick(Item.Info var0) {
        super(var0);
    }

    @Override
    public boolean isFoil(ItemStack var0) {
        return true;
    }

    @Override
    public boolean canAttackBlock(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3) {
        if (!var1.isClientSide) {
            this.handleInteraction(var3, var0, var1, var2, false, var3.getItemInHand(EnumHand.MAIN_HAND));
        }
        return false;
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        BlockPosition var3;
        EntityHuman var1 = var0.getPlayer();
        World var2 = var0.getLevel();
        if (!var2.isClientSide && var1 != null && !this.handleInteraction(var1, var2.getBlockState(var3 = var0.getClickedPos()), var2, var3, true, var0.getItemInHand())) {
            return EnumInteractionResult.FAIL;
        }
        return EnumInteractionResult.sidedSuccess(var2.isClientSide);
    }

    private boolean handleInteraction(EntityHuman var0, IBlockData var1, GeneratorAccess var2, BlockPosition var3, boolean var4, ItemStack var5) {
        if (!var0.canUseGameMasterBlocks()) {
            return false;
        }
        Block var6 = var1.getBlock();
        BlockStateList<Block, IBlockData> var7 = var6.getStateDefinition();
        Collection<IBlockState<?>> var8 = var7.getProperties();
        String var9 = IRegistry.BLOCK.getKey(var6).toString();
        if (var8.isEmpty()) {
            ItemDebugStick.message(var0, IChatBaseComponent.translatable(this.getDescriptionId() + ".empty", var9));
            return false;
        }
        NBTTagCompound var10 = var5.getOrCreateTagElement("DebugProperty");
        String var11 = var10.getString(var9);
        IBlockState<?> var12 = var7.getProperty(var11);
        if (var4) {
            if (var12 == null) {
                var12 = var8.iterator().next();
            }
            IBlockData var13 = ItemDebugStick.cycleState(var1, var12, var0.isSecondaryUseActive());
            var2.setBlock(var3, var13, 18);
            ItemDebugStick.message(var0, IChatBaseComponent.translatable(this.getDescriptionId() + ".update", var12.getName(), ItemDebugStick.getNameHelper(var13, var12)));
        } else {
            var12 = ItemDebugStick.getRelative(var8, var12, var0.isSecondaryUseActive());
            String var13 = var12.getName();
            var10.putString(var9, var13);
            ItemDebugStick.message(var0, IChatBaseComponent.translatable(this.getDescriptionId() + ".select", var13, ItemDebugStick.getNameHelper(var1, var12)));
        }
        return true;
    }

    private static <T extends Comparable<T>> IBlockData cycleState(IBlockData var0, IBlockState<T> var1, boolean var2) {
        return (IBlockData)var0.setValue(var1, (Comparable)ItemDebugStick.getRelative(var1.getPossibleValues(), var0.getValue(var1), var2));
    }

    private static <T> T getRelative(Iterable<T> var0, @Nullable T var1, boolean var2) {
        return var2 ? SystemUtils.findPreviousInIterable(var0, var1) : SystemUtils.findNextInIterable(var0, var1);
    }

    private static void message(EntityHuman var0, IChatBaseComponent var1) {
        ((EntityPlayer)var0).sendSystemMessage(var1, ChatMessageType.GAME_INFO);
    }

    private static <T extends Comparable<T>> String getNameHelper(IBlockData var0, IBlockState<T> var1) {
        return var1.getName(var0.getValue(var1));
    }
}

