/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;

public class AdventureModeCheck {
    private final String tagName;
    @Nullable
    private ShapeDetectorBlock lastCheckedBlock;
    private boolean lastResult;
    private boolean checksBlockEntity;

    public AdventureModeCheck(String var0) {
        this.tagName = var0;
    }

    private static boolean areSameBlocks(ShapeDetectorBlock var0, @Nullable ShapeDetectorBlock var1, boolean var2) {
        if (var1 == null || var0.getState() != var1.getState()) {
            return false;
        }
        if (!var2) {
            return true;
        }
        if (var0.getEntity() == null && var1.getEntity() == null) {
            return true;
        }
        if (var0.getEntity() == null || var1.getEntity() == null) {
            return false;
        }
        return Objects.equals(var0.getEntity().saveWithId(), var1.getEntity().saveWithId());
    }

    public boolean test(ItemStack var0, IRegistry<Block> var1, ShapeDetectorBlock var2) {
        if (AdventureModeCheck.areSameBlocks(var2, this.lastCheckedBlock, this.checksBlockEntity)) {
            return this.lastResult;
        }
        this.lastCheckedBlock = var2;
        this.checksBlockEntity = false;
        NBTTagCompound var3 = var0.getTag();
        if (var3 != null && var3.contains(this.tagName, 9)) {
            NBTTagList var4 = var3.getList(this.tagName, 8);
            for (int var5 = 0; var5 < var4.size(); ++var5) {
                String var6 = var4.getString(var5);
                try {
                    ArgumentBlockPredicate.b var7 = ArgumentBlockPredicate.parse(HolderLookup.forRegistry(var1), new StringReader(var6));
                    this.checksBlockEntity |= var7.requiresNbt();
                    if (var7.test(var2)) {
                        this.lastResult = true;
                        return true;
                    }
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        this.lastResult = false;
        return false;
    }
}

