/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvilAbstract;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSmithing;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class ContainerSmithing
extends ContainerAnvilAbstract {
    private final World level;
    @Nullable
    private RecipeSmithing selectedRecipe;
    private final List<RecipeSmithing> recipes;

    public ContainerSmithing(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerSmithing(int var0, PlayerInventory var1, ContainerAccess var2) {
        super(Containers.SMITHING, var0, var1, var2);
        this.level = var1.player.level;
        this.recipes = this.level.getRecipeManager().getAllRecipesFor(Recipes.SMITHING);
    }

    @Override
    protected boolean isValidBlock(IBlockData var0) {
        return var0.is(Blocks.SMITHING_TABLE);
    }

    @Override
    protected boolean mayPickup(EntityHuman var0, boolean var1) {
        return this.selectedRecipe != null && this.selectedRecipe.matches(this.inputSlots, this.level);
    }

    @Override
    protected void onTake(EntityHuman var02, ItemStack var12) {
        var12.onCraftedBy(var02.level, var02, var12.getCount());
        this.resultSlots.awardUsedRecipes(var02);
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.access.execute((var0, var1) -> var0.levelEvent(1044, (BlockPosition)var1, 0));
    }

    private void shrinkStackInSlot(int var0) {
        ItemStack var1 = this.inputSlots.getItem(var0);
        var1.shrink(1);
        this.inputSlots.setItem(var0, var1);
    }

    @Override
    public void createResult() {
        List<RecipeSmithing> var0 = this.level.getRecipeManager().getRecipesFor(Recipes.SMITHING, this.inputSlots, this.level);
        if (var0.isEmpty()) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        } else {
            this.selectedRecipe = var0.get(0);
            ItemStack var1 = this.selectedRecipe.assemble(this.inputSlots);
            this.resultSlots.setRecipeUsed(this.selectedRecipe);
            this.resultSlots.setItem(0, var1);
        }
    }

    @Override
    protected boolean shouldQuickMoveToAdditionalSlot(ItemStack var0) {
        return this.recipes.stream().anyMatch(var1 -> var1.isAdditionIngredient(var0));
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack var0, Slot var1) {
        return var1.container != this.resultSlots && super.canTakeItemForPickAll(var0, var1);
    }
}

