/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.time.Instant;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.SignatureValidator;

public record ProfilePublicKey(a data) {
    public static final Codec<ProfilePublicKey> TRUSTED_CODEC = a.CODEC.comapFlatMap(var0 -> {
        try {
            return DataResult.success((Object)ProfilePublicKey.createTrusted(var0));
        }
        catch (CryptographyException var1) {
            return DataResult.error((String)"Malformed public key");
        }
    }, ProfilePublicKey::data);

    public static ProfilePublicKey createTrusted(a var0) throws CryptographyException {
        return new ProfilePublicKey(var0);
    }

    public static ProfilePublicKey createValidated(SignatureValidator var0, a var1) throws InsecurePublicKeyException, CryptographyException {
        if (var1.hasExpired()) {
            throw new InsecurePublicKeyException.InvalidException("Expired profile public key");
        }
        if (!var1.validateSignature(var0)) {
            throw new InsecurePublicKeyException.InvalidException("Invalid profile public key signature");
        }
        return ProfilePublicKey.createTrusted(var1);
    }

    public SignatureValidator createSignatureValidator() {
        return SignatureValidator.from(this.data.key, "SHA256withRSA");
    }

    public static final class a
    extends Record {
        private final Instant expiresAt;
        final PublicKey key;
        private final byte[] keySignature;
        private static final int MAX_KEY_SIGNATURE_SIZE = 4096;
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.INSTANT_ISO8601.fieldOf("expires_at").forGetter(a::expiresAt), (App)MinecraftEncryption.PUBLIC_KEY_CODEC.fieldOf("key").forGetter(a::key), (App)ExtraCodecs.BASE64_STRING.fieldOf("signature").forGetter(a::keySignature)).apply((Applicative)var0, a::new));

        public a(PacketDataSerializer var0) {
            this(var0.readInstant(), var0.readPublicKey(), var0.readByteArray(4096));
        }

        public a(Instant var0, PublicKey var1, byte[] var2) {
            this.expiresAt = var0;
            this.key = var1;
            this.keySignature = var2;
        }

        public void write(PacketDataSerializer var0) {
            var0.writeInstant(this.expiresAt);
            var0.writePublicKey(this.key);
            var0.writeByteArray(this.keySignature);
        }

        boolean validateSignature(SignatureValidator var0) {
            return var0.validate(this.signedPayload().getBytes(StandardCharsets.US_ASCII), this.keySignature);
        }

        private String signedPayload() {
            String var0 = MinecraftEncryption.rsaPublicKeyToString(this.key);
            return this.expiresAt.toEpochMilli() + var0;
        }

        public boolean hasExpired() {
            return this.expiresAt.isBefore(Instant.now());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "expiresAt;key;keySignature", "expiresAt", "key", "keySignature"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "expiresAt;key;keySignature", "expiresAt", "key", "keySignature"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "expiresAt;key;keySignature", "expiresAt", "key", "keySignature"}, this, var0);
        }

        public Instant expiresAt() {
            return this.expiresAt;
        }

        public PublicKey key() {
            return this.key;
        }

        public byte[] keySignature() {
            return this.keySignature;
        }
    }
}

