/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinAI;

public class BehaviorRememberHuntedHoglin<E extends EntityPiglin>
extends Behavior<E> {
    public BehaviorRememberHuntedHoglin() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.HUNTED_RECENTLY, (Object)((Object)MemoryStatus.REGISTERED)));
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        if (this.isAttackTargetDeadHoglin(var1)) {
            PiglinAI.dontKillAnyMoreHoglinsForAWhile(var1);
        }
    }

    private boolean isAttackTargetDeadHoglin(E var0) {
        EntityLiving var1 = ((EntityPiglin)var0).getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        return var1.getType() == EntityTypes.HOGLIN && var1.isDeadOrDying();
    }
}

