/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;

public class BehaviorAdmireTimeout<E extends EntityPiglin>
extends Behavior<E> {
    private final int maxTimeToReachItem;
    private final int disableTime;

    public BehaviorAdmireTimeout(int var0, int var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ADMIRING_ITEM, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.DISABLE_WALK_TO_ADMIRE_ITEM, (Object)((Object)MemoryStatus.REGISTERED)));
        this.maxTimeToReachItem = var0;
        this.disableTime = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        return ((EntityLiving)var1).getOffhandItem().isEmpty();
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        BehaviorController<EntityPiglin> var4 = ((EntityPiglin)var1).getBrain();
        Optional<Integer> var5 = var4.getMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM);
        if (!var5.isPresent()) {
            var4.setMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM, 0);
        } else {
            int var6 = var5.get();
            if (var6 > this.maxTimeToReachItem) {
                var4.eraseMemory(MemoryModuleType.ADMIRING_ITEM);
                var4.eraseMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM);
                var4.setMemoryWithExpiry(MemoryModuleType.DISABLE_WALK_TO_ADMIRE_ITEM, true, this.disableTime);
            } else {
                var4.setMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM, var6 + 1);
            }
        }
    }
}

